#ifndef _VIDEO_H_
#define _VIDEO_H_

void out_char(int x, int y, char c, char attr);
void out_string(int x, int y, char *s, char attr);
void out_hotstring(int x, int y, char *s, char attr1, char attr2);
void fill(int x, int y, int w, int h, char c, char attr);
void set_attr(int x, int y, int w, int h, char attr);

void out_char(int x, int y, char c, char attr)
{
  asm
  {
      push   es
      mov    ax,  0B800h
      mov    es,  ax
      mov    di,  y
      shl    di,  7
      mov    bx,  y
      shl    bx,  5
      add    di,  bx
      mov    bx,  x
      shl    bx,  1
      add    di,  bx
      mov    al,  c
      mov    ah,  attr
      stosw
      pop    es
  }
}

void out_string(int x, int y, char *s, char attr)
{
  int i = 0;
  while (*s) out_char(x + i++, y, *s++, attr);
}

void out_hotstring(int x, int y, char *s, char attr1, char attr2)
{
  int j = 0;
  char attr = attr1;

  while (*s)
  {
    if (*s == '~')
      if (attr == attr1)
        attr = attr2;
      else
        attr = attr1;
    else
      out_char(x + j++, y, *s, attr);
    s++;
  }
}

void fill(int x, int y, int w, int h, char c, char attr)
{
  asm
  {
      push   es
      mov    ax,  0B800h
      mov    es,  ax
      mov    di,  y
      shl    di,  7
      mov    bx,  y
      shl    bx,  5
      add    di,  bx
      mov    bx,  x
      shl    bx,  1
      add    di,  bx
      mov    al,  c
      mov    ah,  attr
      mov    cx,  h
@@1:  push   cx
      mov    cx,  w
      rep    stosw
      mov    bx,  w
      shl    bx,  1
      sub    di,  bx
      add    di,  160
      pop    cx
      loop   @@1
      pop    es
  }
}

void set_attr(int x, int y, int w, int h, char attr)
{
  asm
  {
      push   es
      mov    ax,  0B800h
      mov    es,  ax
      mov    di,  y
      shl    di,  7
      mov    bx,  y
      shl    bx,  5
      add    di,  bx
      mov    bx,  x
      shl    bx,  1
      add    di,  bx
      inc    di
      mov    al,  attr
      mov    cx,  h
@@1:  push   cx
      mov    cx,  w
@@2:  stosb
      inc    di
      loop   @@2
      pop    cx
      mov    bx,  w
      shl    bx,  1
      sub    di,  bx
      add    di,  160
      loop   @@1
      pop    es
  }
}

#endif