#ifndef _PANEL_H_
#define _PANEL_H_
#include <fstream.h>
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include "utils.h"
#include "video.h"
#include "defs.h"
#include "kb.h"
#include "clock.h"
#include "view.h"

struct WadStruct {
  unsigned long offs;
  unsigned long size;
  char name[9];
  WadStruct *next, *prev;
};

class TPanel {
    int x, y, pos;
    void Draw();
    void Activate();
    void Deactivate();
    void DrawActive(int n);
    int Check();
    int active;
    int items;
    int real_items;
  public:
    WadStruct *beg, *p, *end;
    TPanel(int x, int y, WadStruct *t);
    ~TPanel();
    void SetList(WadStruct *beg);
    void SetActive();
    void SetNotActive();
    void Handle(char key, char scan);
    void Del();
    void Insert();
    void Extract(char *);
    void DrawList();
    void Clear();
    void View(char *wadname);
};

TPanel::TPanel(int x, int y, WadStruct *t)
{
  TPanel::x = x;
  TPanel::y = y;
  beg = end = p = NULL;
  active = 0;
  SetList(t);
}

TPanel::~TPanel()
{
}

void TPanel::Draw()
{
  DrawFrame(x, y, 40, 23, PANEL_COLOR);
  fill(x + 1, y + 1, 38, 21, ' ', PANEL_TEXT);
  out_char(x, y + 20, '', PANEL_COLOR);
  fill(x + 1, y + 20, 38, 1, '', PANEL_COLOR);
  out_char(x + 39, y + 20, '', PANEL_COLOR);
  for (int i = 0; i < 2; i++)
  {
    out_char(x + 13 + i * 13, y, '', PANEL_COLOR);
    fill(x + 13 + i * 13, y + 1, 1, 20, '', PANEL_COLOR);
    out_char(x + 13 + i * 13, y + 20, '', PANEL_COLOR);
  }
  out_string(x + 5, y + 1, "Name", PANEL_HEADER);
  out_string(x + 17, y + 1, "Offset", PANEL_HEADER);
  out_string(x + 31, y + 1, "Size", PANEL_HEADER);
}

void TPanel::DrawList()
{
  for (int i = 0; i < 18; i++)
    DrawActive(i);
}

void TPanel::DrawActive(int n)
{
  char s[15];
  int attr;
  WadStruct *from = p;

  for (int i = 0; i < n; i++)
  {
    from = from -> next;
    if (from == NULL) return;
  }

  for (int i = 0; i < 2; i++)
    out_char(x + 13 + i * 13, y + n + 2, '', PANEL_COLOR);

  if ((from -> name == strstr(from -> name, "MAP")) ||
       strstr(from -> name, "_START") ||
       strstr(from -> name, "_END"))
  {
    fill(x + 14, y + n + 2, 12, 1, ' ', PANEL_TEXT);
    fill(x + 27, y + n + 2, 12, 1, ' ', PANEL_TEXT);
    attr = PANEL_DIREC;
  }
  else
  {
    ltoa(from -> offs, s, 10);
    out_string(x + 14, y + n + 2, s, PANEL_NUM);
    fill(x + 14 + strlen(s), y + n + 2, 12 - strlen(s), 1, ' ', PANEL_NUM);
    ltoa(from -> size, s, 10);
    out_string(x + 27, y + n + 2, s, PANEL_NUM);
    fill(x + 27 + strlen(s), y + n + 2, 12 - strlen(s), 1, ' ', PANEL_NUM);
    attr = PANEL_TEXT;
  }
  out_string(x + 1, y + n + 2, from -> name, attr);
  fill(x + 1 + strlen(from -> name), y + n + 2,
       12 - strlen(from -> name), 1, ' ', attr);
}

void TPanel::SetList(WadStruct *beg)
{
  Draw();
  TPanel::beg = beg;
  p = beg;
  WadStruct *t = p;
  items = 0;
  pos = 0;
  real_items = 0;
  while (t -> next != NULL)
  {
    t = t -> next;
    items++;
    real_items++;
  }
  if (items > 19)
    items = 19;
  else
    items += 2;
  end = t;
  DrawList();
  if (active) Activate();
}

void TPanel::Activate()
{
  WadStruct *t = p;
  set_attr(x + 1, y + pos + 2, 38, 1, PANEL_SEL);
  fill(x + 2, y + 21, 8, 1, ' ', PANEL_COLOR);
  for (int i = 0; i < pos; i++)
    t = t -> next;
  out_string(x + 2, y + 21, t -> name, PANEL_COLOR);
}

void TPanel::Deactivate()
{
  DrawActive(pos);
}

void TPanel::SetActive()
{
  active = 1;
  if (beg != NULL) Activate();
}

void TPanel::SetNotActive()
{
  active = 0;
  if (beg != NULL) Deactivate();
}

int TPanel::Check()
{
  WadStruct *t = p;
  int i;

  for (i = 0; i < 19; i++)
  {
    if (t == NULL) return i;
    t = t -> next;
  }

  return i;
}

void TPanel::Handle(char key, char scan)
{
  int i;
  WadStruct *t;

  switch (scan)
  {
    case 80: if (pos < items - 2)
             {
               DrawActive(pos);
               pos++;
               Activate();
             }
             else if (Check() == 19)
             {
               p = p -> next;
               DrawList();
               Activate();
             }
             break;
    case 72: if (pos)
             {
               DrawActive(pos);
               pos--;
               Activate();
             }
             else if (p -> prev != NULL)
             {
               p = p -> prev;
               DrawList();
               Activate();
             }
             break;
    case 73: for (i = 0; (i < 18) && (p -> prev != NULL); i++)
               p = p -> prev;
             if (!i)
             {
               if (pos)
               {
                 DrawActive(pos);
                 pos = 0;
                 Activate();
               }
             }
             else
             {
               DrawList();
               Activate();
             }
             break;
    case 81: if (Check() >= 18)
             {
               t = p;
               for (i = 0; i < 18; i++)
                 t = t -> next;
               for (i = 0; (i < 19) && (t != NULL); i++)
               {
                 p = p -> next;
                 t = t -> next;
               }
               if (!i)
               {
                 DrawActive(pos);
                 pos = 17;
                 Activate();
               }
               else
               {
                 DrawList();
                 Activate();
               }
             }
             break;
    case 71: if (p != beg)
             {
               p = beg;
               DrawList();
             }
             DrawActive(pos);
             pos = 0;
             Activate();
             break;
    case 79: t = end;
             for (i = 0; (i < 17) && (t -> prev != NULL); i++)
               t = t -> prev;
             if (p != t)
             {
               p = t;
               DrawList();
             }
             else
               DrawActive(pos);
             if (pos != i)
             {
               pos = i;
               Activate();
             }
             else
               Activate();
             break;
  }
}

void TPanel::Insert()
{
  char item[10] = "newitem";

  if (InputBox("Open WAD file", "Enter file name:", 9, item, item))
    return;

  WadStruct *t = p, *s = new WadStruct;
  for (int i = 0; i < pos; i++)
    t = t -> next;

  *s = *t;
  s -> size = 0;
  s -> next = t;
  t -> prev -> next = s;

  DrawList();
  Activate();
}

void TPanel::Extract(char *wadname)
{
  char item[10];

  WadStruct *t = p;
  for (int i = 0; i < pos; i++)
    t = t -> next;

  strcpy(item, t -> name);
  if (InputBox("Open WAD file", "Enter file name:", 9, item, item))
    return;

  ifstream wad(wadname, ios::binary);
  wad.seekg(t -> offs, ios::beg);
  ofstream f(item, ios::binary);
  char *buf = new char[512];

  for (int i = 0; i < t -> size / 512; i++)
  {
    wad.read(buf, 512);
    f.write(buf, 512);
  }
  wad.read(buf, t -> size % 512);
  f.write(buf, t -> size % 512);

  delete buf;
  f.close();
  wad.close();
}

void TPanel::Del()
{
  WadStruct *t = p;

  for (int i = 0; i < pos; i++)
    t = t -> next;

  if (t == beg)
  {
    beg = t -> next;
    p = p -> next;
  }
  else
    t -> prev -> next = t -> next;
  if (t == end)
    end = t -> prev;
  else
    t -> next -> prev = t -> prev;
  if (p == t) p = p -> next;
  delete t;
  real_items--;
  if (real_items > 19)
    items = 19;
  else
    items += 2;

  t = end;
  for (int i = 0; (i < 17) && (t -> prev != NULL); i++)
    t = t -> prev;
  if (p == t -> next)
    p = p -> prev;

  DrawList();
  Activate();
}

void TPanel::Clear()
{
  WadStruct *t = p;

  for (int i = 0; i < pos; i++)
    t = t -> next;

  t -> size = 0;

  Handle(0, 80);
}

void TPanel::View(char *wadname)
{
  WadStruct *t = p;
  ifstream wad(wadname, ios::binary);
  char *buf = new char[512];

  for (int i = 0; i < pos; i++)
    t = t -> next;

  wad.seekg(t -> offs, ios::beg);
  wad.read(buf, 512);
  ViewWindow(buf, t -> size);
  delete buf;

  wad.close();
}


#endif
