#ifndef _KB_H_
#define _KB_H_

void Wait(void);
char ReadKey(void);
char Ins(void);
char Caps(void);
char Scroll(void);
char NumLock(void);
char RightShift(void);
char LeftShift(void);
char Alt(void);
char Ctrl(void);
char RifhtAlt(void);
char LeftAlt(void);
char RightCtrl(void);
char LeftCtrl(void);
void ReInitKb(void);
unsigned char Get1Attr(void);
unsigned char Get2Attr(void);
unsigned char Keypressed(void);
void ClearBuf(void);

void Wait(void)
{
  asm xor ax, ax
  asm int 16h
}

char ReadKey(void)
{
  char chr, scn;
  asm
  {
    xor ax, ax
    int 16h
    mov chr, al
    mov scn, ah
  }
  if (chr==0) return scn;
  return chr;
}

char Ins(void)
{
  if (Get1Attr()&&128) return 1;
  return 0;
}

char Caps(void)
{
  if (Get1Attr() & 64) return 1;
  return 0;
}

char Scroll(void)
{
  if (Get1Attr() & 16) return 1;
  return 0;
}

char NumLock(void)
{
  if (Get1Attr() & 32) return 1;
  return 0;
}

char RightShift(void)
{
  if (Get1Attr() & 1) return 1;
  return 0;
}

char LeftShift(void)
{
  if (Get1Attr() & 2) return 1;
  return 0;
}

char Alt(void)
{
  if (Get1Attr() & 8) return 1;
  return 0;
}

char Ctrl(void)
{
  if (Get1Attr() & 4) return 1;
  return 0;
}

char RifhtAlt(void)
{
  if (Get2Attr() & 8) return 1;
  return 0;
}

char LeftAlt(void)
{
  if (Get2Attr() & 2) return 1;
  return 0;
}

char RightCtrl(void)
{
  if (Get2Attr() & 4) return 1;
  return 0;
}

char LeftCtrl(void)
{
  if (Get2Attr() & 1) return 1;
  return 0;
}

void ReInitKb(void)
{
   asm mov al, 0FFh
   asm out 60h, al
}

unsigned char Get1Attr(void)
{
  char res;
  asm
  {
    push ds
    mov ax, 40h
    mov ds, ax
    mov si, 17h
    lodsb
    mov res, al
    pop ds
  }
  return res;
}

unsigned char Get2Attr(void)
{
  char res;
  asm
  {
    push ds
    mov ax, 40h
    mov ds, ax
    mov si, 18h
    lodsb
    mov res, al
    pop ds
  }
  return res;
}

unsigned char Keypressed(void)
{
  char res;
  asm
  {
    mov ax, 40h
    mov ds, ax
    mov si, 1Ch
    lodsb
    mov bl, al
    mov si, 1Ah
    lodsb
    mov res, 0
    cmp al, bl
    jne @1
@1: mov res, 1
  }
  return res;
}

void ClearBuf(void)
{
  asm xor al, al
  asm mov ah, 0Ch
  asm int 21h
}

#endif
