#include <fstream.h>
#include <stdlib.h>
#include <string.h>
#include <new.h>
#include <dir.h>
#include <dos.h>

struct HEADER {
  char ID[5];
  char temp[3];
  unsigned offs1;
  unsigned offs2;
} h;

struct TList {
  unsigned long offs;
  unsigned long size;
  char     name[9];
  TList    *next;
} *beg = NULL, *end = NULL;

ifstream in("doom2.wad", ios::binary);

void Read()
{
  TList *t;
  in.read((unsigned char *)&h, 12);
  in.seekg((long)h.offs2 * 0x10000 + h.offs1, ios::beg);

  t = new TList;
  in.read((unsigned char *)t, 16);

  while (in.gcount())
  {
    t -> name[8] = 0;
    t -> next = NULL;
    if (beg == NULL)
      beg = t;
    else
      end -> next = t;
    end = t;
    t = new TList;
    in.read((unsigned char *)t, 16);
  }
  in.close();
  in.open("doom2.wad", ios::binary);

  delete t;
}

void FreeAll()
{
  TList *t = beg;

  while (t)
  {
    beg = t -> next;
    delete t;
    t = beg;
  }
}

void Write()
{
  TList *t = beg;
  unsigned char *buf = new char[512];
  int mapmode = 0, n;

  while (t)
  {
    if (!t -> size)
    {
      if (strstr(t -> name, "MAP") != NULL)
      {
        mkdir(t -> name);
        chdir(t -> name);
        cout << "Creating ";
        getcurdir(6, buf);
        cout << buf << "\n";
        mapmode = 1;
        n = 0;
      }
      else if (strstr(t -> name, "_S") != NULL)
      {
        mkdir(t -> name);
        chdir(t -> name);
        cout << "Creating ";
        getcurdir(6, buf);
        cout << buf << "\n";
      }
      else if ((strstr(t -> name, "_E") != NULL) && (strstr(t -> name, "MUS") == NULL))
      {
        chdir("..");
        getcurdir(6, buf);
        cout << "Changing " << buf << "\n";
      }
    }
    else
    {
      cout << "Extracting ";
      getcurdir(6, buf);
      strcat(buf, "\\");
      strcat(buf, t -> name);
      strcat(buf, "...");
      cout << buf;
      in.seekg(t -> offs, ios::beg);
      ofstream out(t -> name, ios::binary);
      for (int i = 0; i < t -> size / 512; i++)
      {
        in.read((unsigned char *)buf, 512);
        out.write(buf, 512);
      }
      if (t -> size % 512)
      {
        in.read(buf, t -> size % 512);
        out.write(buf, t -> size % 512);
      }
      out.close();
      cout << "Ok\n";
      if (mapmode) n++;
      if ((n == 10) && mapmode)
      {
        chdir("..");
        mapmode = 0;
      }
    }
    t = t -> next;
  }

  delete buf;
}

void my_handler()
{
  cout << "Error: not enough memory\n";
  exit(1);
}

void main()
{
  set_new_handler(my_handler);

  if (!in)
  {
    cout << "Unable to open doom2.WAD\n";
    return;
  }

  Read();
  mkdir("DOOMDATA");
  chdir("DOOMDATA");
  Write();
  chdir("..");
  FreeAll();

  in.close();
}
