#ifndef _CHDIR_H_
#define _CHDIR_H_
#include <stdio.h>
#include <conio.h>
#include <dir.h>
#include <dos.h>
#include "defs.h"
#include "video.h"
#include "clock.h"

void ChdirBox();

struct TItem {
  char text[20];
  TItem *next;
};

class TList {
    int x;
    int y;
    int w;
    int h;
    TItem *beg_list, *end_list;
  public:
    int pos;
    TList(int, int, int, int);
    ~TList();
    void Add(char *);
    void Clear();
    void Draw(int);
    char *GetItem(int);
};

TList::TList(int x, int y, int w, int h)
{
  TList::x = x;
  TList::y = y;
  TList::w = w;
  TList::h = h;
  pos = 0;
  beg_list = NULL;
  end_list = NULL;
  Draw(0);
}

TList::~TList()
{
  Clear();
}

void TList::Add(char *text)
{
  TItem *p = new TItem;
  p -> next = NULL;
  strcpy(p -> text, text);
  if (beg_list == NULL)
    beg_list = p;
  else
    end_list -> next = p;
  end_list = p;
}

char *TList::GetItem(int pos)
{
  TItem *t = beg_list;
  int i = 0;

  while(t && i < pos)
  {
    t = t -> next;
    i++;
  }

  return t -> text;
}

void TList::Clear()
{
  TItem *t = beg_list;

  while (t)
  {
    beg_list = t -> next;
    delete t;
    t = beg_list;
  }
}

void TList::Draw(int n)
{
  TItem *t = beg_list;
  int x_ = 0, y_ = 0, j = 0, i = 0;
  char attr;

  for (int i = 0; i < w / 16; i++)
    fill(x + (i + 1) * 16 - 1, y, 1, h, '', LIST_SEPCOLOR);

  while (t && j < pos)
  {
    t = t -> next;
    j++;
  }

  while (t && i < h * (w / 16 + 1))
  {
    if (i == n)
      attr = LIST_SELITEMCOLOR;
    else
      attr = LIST_ITEMCOLOR;
    out_char(x + x_, y + y_, ' ', attr);
    out_string(x + 1 + x_, y + y_, t -> text, attr);
    fill(x + x_ + strlen(t -> text) + 1, y + y_, 15 - strlen(t -> text) - 1, 1, ' ', attr);
    t = t -> next;
    y_++;
    if (y_ > h - 1)
    {
      y_ = 0;
      x_ += 16;
    }
    i++;
  }
  while (i < h * (w / 16 + 1))
  {
    fill(x + x_, y + y_, 15, 1, ' ', LIST_ITEMCOLOR);
    y_++;
    if (y_ > h - 1)
    {
      y_ = 0;
      x_ += 16;
    }
    i++;
  }
}

void PrintDir(int x, int y)
{
  char *dir = new char[100];
  char *t = new char[100];
  char *s = dir;
  getcurdir(getdisk() + 1, dir);
  if (strlen(dir) > 24)
  {
    while (strlen(dir) > 24)
    {
      while (*dir++ != '\\');
    }
    strcpy(t, " :\\...\\");
  }
  else
  {
    strcpy(t, " :\\");
  }
  strcat(t, dir);
  *t = getdisk() + 'A';
  out_string(x, y, t, EDIT_TEXTCOLOR);
  fill(x + strlen(t), y, 31 - strlen(t), 1, ' ', EDIT_TEXTCOLOR);
  delete t;
  delete s;
}

void ChdirBox()
{
  char key, *buf = new char[2000];
  char title[20] = "Change directory";
  int w = 37, h = 16, done;
  int x = 40 - w / 2, y = 12 - h / 2;
  int pos = 0, old_pos = 0, numfiles = 0, offs = 0, old_offs = 0;
  ffblk ffblk;

  gettext(x + 1, y + 1, x + w + 2, y + h + 1, buf);

  fill(x + 1, y, w - 2, 1, '', MSG_FRAMECOLOR);
  fill(x + 1, y + h - 1, w - 2, 1, '', MSG_FRAMECOLOR);
  fill(x, y + 1, 1, h - 2, '', MSG_FRAMECOLOR);
  fill(x + w - 1, y + 1, 1, h - 2, '', MSG_FRAMECOLOR);
  out_char(x, y, '', MSG_FRAMECOLOR);
  out_char(x + w - 1, y, '', MSG_FRAMECOLOR);
  out_char(x, y + h - 1, '', MSG_FRAMECOLOR);
  out_char(x + w - 1, y + h - 1, '', MSG_FRAMECOLOR);
  fill(x + 1, y + 1, w - 2, h - 2, ' ', MSG_TEXTCOLOR);

  out_char(39 - strlen(title) / 2, y, ' ', MSG_FRAMECOLOR);
  out_string(40 - strlen(title) / 2, y, title, MSG_FRAMECOLOR);
  out_char(40 - strlen(title) / 2 + strlen(title), y, ' ', MSG_FRAMECOLOR);
  out_string(x + 3, y + 14, "Esc - Cancel", MSG_TEXTCOLOR);

  set_attr(x + w, y + 1, 2, h, SHADOW_COLOR);
  set_attr(x + 2, y + h, w, 1, SHADOW_COLOR);

  TList *list = new TList(x + 3, y + 2, 31, 10);

  done = findfirst("*.*", &ffblk, 16);
  while (!done)
  {
    if (strcmp(ffblk.ff_name, ".") && (ffblk.ff_attrib & 16))
    {
      list -> Add(ffblk.ff_name);
      numfiles++;
    }
    done = findnext(&ffblk);
  }
  list -> Draw(pos);

  PrintDir(x + 3, y + 12);

  do
  {
    if (kbhit())
    {
      key = getch();
      switch (key)
      {
        case 80: if ((pos < 19) && (pos < numfiles - 1))
                   pos++;
                 else if (offs < numfiles - 20)
                   offs ++;
                 break;
        case 72: if (pos)
                   pos--;
                 else if (offs)
                   offs--;
                 break;
        case 77: if ((pos < 9) && (pos < numfiles - 1) && (pos + 10 < numfiles))
                   pos += 10;
                 else
                 {
                   if (numfiles < 20)
                   {
                     if (pos != numfiles - 1)
                       pos = numfiles - 1;
                   }
                   else
                   {
                     if (pos != 19)
                       pos = 19;
                     else if (numfiles > 20)
                     {
                       if (offs < numfiles - 30)
                         offs += 10;
                       else
                         offs = numfiles - 20;
                     }
                   }
                 }
                 break;
        case 75: if (pos > 9)
                   pos -= 10;
                 else
                 {
                   if (pos)
                     pos = 0;
                   else
                   {
                     if (offs > 10)
                       offs -= 10;
                     else
                       offs = 0;
                   }
                 }
                 break;
        case 71: pos = 0; offs = 0; break;
        case 79: pos = 19;
                 if (pos > numfiles - 1)
                   pos = numfiles - 1;
                 offs = numfiles - 20;
                 if (offs < 0)
                   offs = 0;
                 break;
        case 13: chdir(list -> GetItem(pos + offs));

                 PrintDir(x + 3, y + 12);
                 list -> Clear();

                 pos = 0;
                 offs = 0;
                 numfiles = 0;

                 done = findfirst("*.*", &ffblk, 16);
                 while (!done)
                 {
                   if (strcmp(ffblk.ff_name, ".") && (ffblk.ff_attrib & 16))
                   {
                     list -> Add(ffblk.ff_name);
                     numfiles++;
                   }
                   done = findnext(&ffblk);
                 }
                 list -> Draw(pos);
                 break;
      }
    }
    if ((pos != old_pos) || (offs != old_offs))
    {
      list -> pos = offs;
      list -> Draw(pos);
    }
    UpdateClock();
    old_pos = pos;
    old_offs = offs;
  } while ((key != 27));

  puttext(x + 1, y + 1, x + w + 2, y + h + 1, buf);
  delete buf;
}

#endif
