class InventoryRandomSpawner : Inventory
{
    
    const MAX_RANDOMSPAWNERS_RECURSION = 32; // Should be largely more than enough, honestly.
    
    Default
    {
        +NOBLOCKMAP
        +NOSECTOR
        +NOGRAVITY
        +THRUACTORS
    }
    virtual void PostSpawn(actor spawned) 
    {
        if (!spawned)
            return;
        let am = Inventory(spawned);
        if (am) {
            if (bTOSSED) {
                am.bTOSSED = true;
                am.amount = Clamp(am.amount / 2, 1, am.amount);
            }
            else
                am.bDROPPED = false;
        } 
    }
 
    // Override this to decide what to spawn in some other way.
    // Return the class name, or 'None' to spawn nothing, or 'Unknown' to spawn an error marker.
    virtual Name ChooseSpawn()
    {
        DropItem di;   // di will be our drop item list iterator
        DropItem drop; // while drop stays as the reference point.
        int n = 0;
        bool nomonsters = sv_nomonsters || level.nomonsters;
 
        drop = di = GetDropItems();
        if (di != null)
        {
            while (di != null)
            {
                bool shouldSkip = (di.Name == 'None');
                
                if (!shouldSkip)
                {
                    int amt = di.Amount;
                    if (amt < 0) amt = 1; // default value is -1, we need a positive value.
                    n += amt; // this is how we can weight the list.
                }
 
                di = di.Next;
            }
            if (n == 0)
            { // Nothing left to spawn.
                return 'None';
            }
            // Then we reset the iterator to the start position...
            di = drop;
            // Take a random number...
            n = random[randomspawn](0, n-1);
            // And iterate in the array up to the random number chosen.
            while (n > -1 && di != null)
            {
                if (di.Name != 'None')
                {
                    int amt = di.Amount;
                    if (amt < 0) amt = 1;
                    n -= amt;
                    if ((di.Next != null) && (n > -1))
                        di = di.Next;
                    else
                        n = -1;
                }
                else
                {
                    di = di.Next;
                }
            }
            if (di == null)
            {
                return 'Unknown';
            }
            else if (random[randomspawn]() <= di.Probability)   // prob 255 = always spawn, prob 0 = almost never spawn.
            {
                return di.Name;
            }
            else
            {
                return 'None';
            }
        }
        else
        {
            return 'None';
        }
    }
    
    // No need to do this in BeginPlay, strictly speaking, but I left it as is since I didn't want to spend too much time on it
    override void BeginPlay()
    {
        Super.BeginPlay();
        let s = ChooseSpawn();
 
        if (s == 'Unknown') // Spawn error markers immediately.
        {
            Spawn(s, Pos, NO_REPLACE);
            Destroy();
        }
        else if (s == 'None') // ChooseSpawn chose to spawn nothing.
        {
            Destroy();
        }
        else
        {
            // So now we can spawn the dropped item.
            Class<Actor> cls = s;
            if (cls != null)
            {
                Class<Actor> rep = GetReplacement(cls);
                if (rep != null)
                {
                    cls = rep;
                }
            }
            if (cls != null)
            {
                Species = Name(cls);
                readonly<Actor> defmobj = GetDefaultByType(cls);
            }
            else
            {
                A_Log(TEXTCOLOR_RED .. "Unknown item class ".. s .." to drop from a random spawner\n");
                Species = 'None';
            }
        }
    }
 
    // The second half of random spawning
    override void PostBeginPlay()
    {
        Super.PostBeginPlay();
 
        if (bouncecount >= MAX_RANDOMSPAWNERS_RECURSION)    // Prevents infinite recursions
        {
            Spawn("Unknown", Pos, NO_REPLACE);      // Show that there's a problem.
            Destroy();
            return;
        }
 
        Actor newmobj = null;
        bool boss = false;
 
        if (Species == 'None')
        {
            Destroy();
            return;
        }
        Class<Actor> cls = Species;
        newmobj = Spawn(cls, Pos, NO_REPLACE);
        if (newmobj != null)
        {
            // copy everything relevant
            newmobj.SpawnAngle = SpawnAngle;
            newmobj.Angle       = Angle;
            newmobj.Pitch       = Pitch;
            newmobj.Roll        = Roll;
            newmobj.SpawnPoint = SpawnPoint;
            newmobj.special    = special;
            newmobj.args[0]    = args[0];
            newmobj.args[1]    = args[1];
            newmobj.args[2]    = args[2];
            newmobj.args[3]    = args[3];
            newmobj.args[4]    = args[4];
            newmobj.special1   = special1;
            newmobj.special2   = special2;
            newmobj.SpawnFlags = SpawnFlags & ~MTF_SECRET;  // MTF_SECRET needs special treatment to avoid incrementing the secret counter twice. It had already been processed for the spawner itself.
            newmobj.HandleSpawnFlags();
            newmobj.SpawnFlags = SpawnFlags;
            newmobj.bCountSecret = SpawnFlags & MTF_SECRET; // "Transfer" count secret flag to spawned actor
            newmobj.ChangeTid(tid);
            newmobj.Vel = Vel;
            newmobj.master = master;    // For things such as DamageMaster/DamageChildren, transfer mastery.
            newmobj.target = target;
            newmobj.tracer = tracer;
            newmobj.CopyFriendliness(self, false);
            // This handles things such as projectiles with the MF4_SPECTRAL flag that have
            // a health set to -2 after spawning, for internal reasons.
            if (health != SpawnHealth()) newmobj.health = health;
            if (!bDropped) newmobj.bDropped = false;
            // Handle special altitude flags
            if (newmobj.bSpawnCeiling)
            {
                newmobj.SetZ(newmobj.ceilingz - newmobj.Height - SpawnPoint.Z);
            }
            else if (newmobj.bSpawnFloat) 
            {
                double space = newmobj.ceilingz - newmobj.Height - newmobj.floorz;
                if (space > 48)
                {
                    space -= 40;
                    newmobj.SetZ((space * random[randomspawn]()) / 256. + newmobj.floorz + 40);
                }
                newmobj.AddZ(SpawnPoint.Z);
            }
            // Bouncecount is used to count how many recursions we're in.
            if (newmobj is 'RandomSpawner')
                newmobj.bouncecount = ++bouncecount;            
 
            PostSpawn(newmobj);
        }
        Destroy();
    }
}

class itsfuckingnothing : actor replaces BFG9000
	{
		 default{
		 }
		 States {
			Spawn:
			TNT1 A 0;
			death:
			Tnt1 a 0;
			stop;
			}
	}

class SevenSixtyDeux : SevenSixtyTwo
		{
		default {
		Inventory.PickupMessage "\cjPicked up a Half-Filled AK Mag.";
		Inventory.Amount 15;
		}	
	}

class ingrammo2 : ingrammo
		{
		default {
		Inventory.PickupMessage "\cjGot a Half-Empty Mac-10 Mag.";
		Inventory.Amount 16;
		}	
	}

class ExtraShades : ArmorBonus
	{
	 default{
     Armor.SaveAmount 5;
	 Inventory.PickupMessage "\cjPicked up a Spare pair of Shades.";
	 Inventory.PickupSound "ExtraShades";
	 }
	 States {
		Spawn:
			TNT1 A 0;
			TNT1 A 0 A_Jump(256,1,2,3,4,5,6,7);
			GLAS ACDEFGH 0 A_Jump(256,"HoldFrame");
			HoldFrame:
			"----" A -1;
			Stop;
		}
}

class ClipReplace1 : InventoryRandomSpawner Replaces Clip
		{
			default{
				DropItem "fiftyae", 255, 1;
				DropItem "ingrammo", 255, 3;
		}
	}

class ClipReplace2 : InventoryRandomSpawner Replaces ClipBox
		{
			default{
				DropItem "FiftyBox", 255, 1;
				DropItem "IngramBox", 255, 3;
		}
	}

class ShellReplace1 : InventoryRandomSpawner Replaces Shell
		{
			default{
				DropItem "twelvegauge", 255, 3;
				DropItem "fiftyae", 255, 1;
		}
	}

class ShellReplace2 : InventoryRandomSpawner Replaces ShellBox
		{
			default{
				DropItem "twelvegaugebox", 255, 2;
				DropItem "fiftybox", 255, 1;
		}
	}

class ExtraSoda : HealthBonus
	{
	 default{
     Inventory.Amount 5;
	 Inventory.PickupMessage "\cjSipped a can of soda.";
	 Inventory.PickupSound "grabasoda";
	 }
	 States {
		Spawn:
			TNT1 A 0;
			TNT1 A 0 A_Jump(256,1,2,3,4,5);
			SODA ABCDE 0 A_Jump(256,"HoldFrame");
			HoldFrame:
			"----" A -1;
			Stop;
		}
}

class ShotReplace : InventoryRandomSpawner Replaces Shotgun
		{
			default{
				DropItem "DesertEagle", 255, 1;
				DropItem "Remington870", 255, 9;
		}
	}
	

class SawReplace : InventoryRandomSpawner Replaces Chainsaw
		{
			default{
				DropItem "DesertEagle", 255, 1;
				DropItem "LeadPipe", 255, 2;
		}
	}


class ammospawn : InventoryRandomSpawner
		{
			default{
				DropItem "ingrammo2";
				DropItem "twelvegauge";
				DropItem "ingrammo2";
				DropItem "twelvegauge";
				DropItem "SevenSixtyDeux";
				DropItem "grenadesforlaunching";
				DropItem "itsfuckingnothing";
				DropItem "itsfuckingnothing";
		}
	}



	class BonusSpawn1 : InventoryRandomSpawner replaces ArmorBonus
		{
			default{
				DropItem "pillshere", 133, 1;
				DropItem "ExtraShades", 255, 1;
				DropItem "ammospawn", 255, 4;
				DropItem "itsfuckingnothing", 0, 16;
		}
	}

	class BonusSpawn2 : InventoryRandomSpawner replaces HealthBonus
		{
			default{
				DropItem "pillshere", 255, 1;
				DropItem "ExtraSoda", 255, 2;
				DropItem "ammospawn", 255, 1;
				DropItem "itsfuckingnothing", 0, 10;
		}
	}

Class BigAidKit : AidKit 
	 {
	Default {
		Inventory.Amount 20;
		Inventory.PickupMessage "\cjUsed a Big Medikit!";
		Health.LowMessage 6, ("\cjYou really fucked up healing a wound, but the demons will kill you before that does.");	
	 }
	 States {
	 Spawn: 
	 FAID K 1;
	 loop;
	 }
}
class AidKit : Stimpack 	 
 {
	Default {
	Inventory.PickupSound "Healing";
	Inventory.Amount 10;
    Inventory.PickupMessage "\cjPatched yourself up!";
	Health.LowMessage 20, ("\cjGauzed Up a Gangrenous Gash!");
	}
	States {
	Spawn: 
	FKIT A 1;
	loop;
	}
}

class Pillshere : HealthPickup 
{
	Default
	{
		Health 15;
		+COUNTITEM
		Scale 1.2;
		Inventory.Icon "PILLA0";
		Inventory.PickupSound "pleasework";
		Inventory.PickupMessage "\cjPicked up a Bottle of Painkillers!";
		Inventory.maxamount 6;
		Inventory.UseSound "Painkilleruse";
		Inventory.InterHubAmount 6;
		Tag "Painkillers";
		HealthPickup.Autouse 0;
	}
	States
	{
	Spawn:
		PILL A -1;
		Loop;
	Use:
		TNT1 A 4 A_SetBlend("0 255 255", .5, 5);
		stop;
	}
}

Class Medkitreplacer : InventoryRandomSpawner replaces Medikit
{
			default{
				DropItem "pillshere", 255, 1;
				DropItem "BigAidKit", 255, 1;
		}
	}
	
Class StimReplace : InventoryRandomSpawner replaces Stimpack
{
			default{
				DropItem "pillshere", 255, 1;
				DropItem "AidKit", 255, 2;
		}
	}

Class KevlarVest : GreenArmor replaces GreenArmor 
	{
	Default {
	scale .75;
	Inventory.PickupMessage "\cjBagged a Bulletproof Vest!";
	Inventory.PickupSound "Equipzip";
	Armor.SavePercent 50;
	Armor.SaveAmount 75;
	}
	States
	{
	Spawn:
    VEST Z 1;
	loop;
	}
}

Class RiotVest : KevlarVest replaces BlueArmor 
	{
	Default {
	scale .75;
	Inventory.PickupMessage "\cjFilched a Flak Jacket!";
	Inventory.PickupSound "flakarmour";
	Armor.SavePercent 50;
	Armor.SaveAmount 200;
	}
	States
	{
	Spawn:
    VEST F 1;
	loop;
	}
}	

Class HazmatSuit : Radsuit replaces Radsuit
	{	
	Default {
	Inventory.PickupSound "Equipzip";
	Inventory.PickupMessage "\cjThis Suit will keep you Safe... Wait, Where's the fucking helmet!?";
	}
	States
	{
	  Spawn:
	  HZMT A 1;
	  Loop;
	}
}

Class Multipackpills: Actor replaces Berserk
{
	States
	{ Spawn:
		TNT1 A 0 Nodelay A_SpawnItemEx("Pillshere",5,-5);
		TNT1 A 0 A_SpawnItemEx("Pillshere",5,5);
		TNT1 A 0 A_SpawnItemEx("Pillshere",-5,-5);
		TNT1 A 0 A_SpawnItemEx("Pillshere",-5,5);
		Stop;
	}
}

Class MegaKit : Soulsphere replaces Soulsphere
{
	Default {
	Inventory.PickupSound "Healing";
    Inventory.PickupMessage "\cvApplied a Megakit!";
	}
	states
	{
	Spawn:
		SKIT A 20 Light("MegakitA");
		SKIT B 5 Light("MegakitB");
		SKIT C 5 Light("MegakitC");
		SKIT D 5 Light("MegakitD");
		SKIT E 5 Light("MegakitE");
		SKIT F 20 Light("MegakitF");
		SKIT E 5 Light("MegakitE");
		SKIT D 5 Light("MegakitD");
		SKIT C 5 Light("MegakitC");
		SKIT B 5 Light("MegakitB");
		Loop;
	Pickup:
		TNT1 A 8 A_SetBlend("0 255 255", .5, 5);
		stop;
	}
}

Class ValkyrInvuln: PowerInvulnerable
{
  override void InitEffect()
  { 
    super.InitEffect();
    if (owner)
      owner.A_StartSound("valkyrsound",12,CHANF_LOOPING);
  }
  override void EndEffect()
  {
    if (owner)
      owner.A_StopSound(12);
    super.EndEffect();
  }
}

class ValkyrDrug : InvulnerabilitySphere replaces InvulnerabilitySphere
{
Default {
  +FLOATBOB;
  scale 0.75;
  Inventory.PickupSound "heroin";
  Inventory.PickupMessage "\cdVALKYR!!!";
  Inventory.Amount 0;
  Powerup.Type "ValkyrInvuln";
  Powerup.Colormap 0.1, 0.9, 0.1, 0.0, 0.1, 0.0;
  +BRIGHT;
  }
  States
	  {
	  Spawn:
		VLKY R -1 Light("Valkyrglow");
		Stop;
	  }
}
