DefineMissileType("missile-deathmatch-item-teleport-fog",
  { File = "units/item-teleport-fog.png", Size = {27, 25}, Frames = 5, NumDirections = 1,
  DrawLevel = drawLevels.DL_OverLandUnit, Class = "missile-class-stay", Sleep = 4, Speed = 8, Range = 0} )

-- Ammo
DefineAnimations("animations-deathmatch-bullet-clip", {
  Still = {"frame 0", "wait 4", "frame 0", "wait 1",},
  Attack = {"unbreakable begin",
	"frame 0", "set-var Op1.Value = 0",
	"if-var t_AmmoBullets.Value == t_AmmoBullets.Max full",
		"set-var AmmoBullets.Value += 10 t",
		"goto end",
	"label full",
		"set-var Op1.Value = 1",
	"label end",
		"if-var v_Op1.Value == 1 notdie",
		"sound deathmatch-item-pickup",
		"lua-callback HandleDoomerMessages t_Slot.Value 4 v_Slot.Value",
		"frame 1", "set-var RespawnTime.Value = 900",	
		"label respawnloop",
		"frame 1", "set-var RespawnTime.Value -= 1",
		"wait 1",
		"if-var v_RespawnTime.Value != 0 respawnloop",
		"spawn-missile missile-deathmatch-item-teleport-fog 0 0 0 0 pixel", "sound deathmatch-item-respawn",
	"label notdie","unbreakable end", "wait 1",},
  Death = {"unbreakable begin","frame 0", "unbreakable end","wait 1",},
})

DefineUnitType("unit-deathmatch-bullet-clip", { Name = "Picked up a clip.",
  Image = {"file", "units/bulletclip.png", "size", {7, 8}},
  Animations = "animations-deathmatch-bullet-clip", Icon = "icon-cancel",
  HitPoints = 15,
  DrawLevel = drawLevels.OnLand,
  TileSize = {1, 1}, BoxSize = {16, 16},
  SightRange = 1, ComputerReactionRange = 0, PersonReactionRange = 0,
  BasicDamage = 1, PiercingDamage = 1, Missile = "missile-none",
  MaxAttackRange = 0,
  Priority = 30,
  Points = 0,
  Type = "land",
  -- Damage and armor part
  IsBuildingArmor = 1,
  ----------------------
  CanTargetFlag = {"DeathMatchDoomer", "only"},
  Indestructible = 1,
  NonSolid = true,
  NumDirections = 1,
  CanAttack = true,
  IsNotSelectable = true,
  CanTargetLand = true,
  LandUnit = true,
  Item = true
} )

DefineAnimations("animations-deathmatch-bullet-box", {
  Still = {"frame 0", "wait 4", "frame 0", "wait 1",},
  Attack = {"unbreakable begin",
	"frame 0", "set-var Op1.Value = 0",
	"if-var t_AmmoBullets.Value == t_AmmoBullets.Max full",
		"set-var AmmoBullets.Value += 50 t",
		"goto end",
	"label full",
		"set-var Op1.Value = 1",
	"label end",
		"if-var v_Op1.Value == 1 notdie",
		"sound deathmatch-item-pickup",
		"lua-callback HandleDoomerMessages t_Slot.Value 4 v_Slot.Value",
		"frame 1", "set-var RespawnTime.Value = 900",	
		"label respawnloop",
		"frame 1", "set-var RespawnTime.Value -= 1",
		"wait 1",
		"if-var v_RespawnTime.Value != 0 respawnloop",
		"spawn-missile missile-deathmatch-item-teleport-fog 0 0 0 0 pixel", "sound deathmatch-item-respawn",
	"label notdie","unbreakable end", "wait 1",},
  Death = {"unbreakable begin","frame 0", "unbreakable end","wait 1",},
})

DefineUnitType("unit-deathmatch-bullet-box", { Name = "Picked up a box of bullets.",
  Image = {"file", "units/ammobox.png", "size", {21, 12}},
  Animations = "animations-deathmatch-bullet-box", Icon = "icon-cancel",
  HitPoints = 15,
  DrawLevel = drawLevels.OnLand,
  TileSize = {1, 1}, BoxSize = {16, 16},
  SightRange = 1, ComputerReactionRange = 0, PersonReactionRange = 0,
  BasicDamage = 1, PiercingDamage = 1, Missile = "missile-none",
  MaxAttackRange = 0,
  Priority = 30,
  Points = 0,
  Type = "land",
  -- Damage and armor part
  IsBuildingArmor = 1,
  ----------------------
  CanTargetFlag = {"DeathMatchDoomer", "only"},
  Indestructible = 1,
  NonSolid = true,
  NumDirections = 1,
  CanAttack = true,
  IsNotSelectable = true,
  CanTargetLand = true,
  LandUnit = true,
  Item = true
} )

DefineAnimations("animations-deathmatch-shells", {
  Still = {"frame 0", "wait 4", "frame 0", "wait 1",},
  Attack = {"unbreakable begin",
	"frame 0", "set-var Op1.Value = 0",
	"if-var t_AmmoShells.Value == t_AmmoShells.Max full",
		"set-var AmmoShells.Value += 4 t",
		"goto end",
	"label full",
		"set-var Op1.Value = 1",
	"label end",
		"if-var v_Op1.Value == 1 notdie",
		"sound deathmatch-item-pickup",
		"lua-callback HandleDoomerMessages t_Slot.Value 4 v_Slot.Value",
		"frame 1", "set-var RespawnTime.Value = 900",	
		"label respawnloop",
		"frame 1", "set-var RespawnTime.Value -= 1",
		"wait 1",
		"if-var v_RespawnTime.Value != 0 respawnloop",
		"spawn-missile missile-deathmatch-item-teleport-fog 0 0 0 0 pixel", "sound deathmatch-item-respawn",
	"label notdie","unbreakable end", "wait 1",},
  Death = {"unbreakable begin","frame 0", "unbreakable end","wait 1",},
})

DefineUnitType("unit-deathmatch-shells", { Name = "Picked up 4 shotgun shells.",
  Image = {"file", "units/shells.png", "size", {11, 5}},
  Animations = "animations-deathmatch-shells", Icon = "icon-cancel",
  HitPoints = 15,
  DrawLevel = drawLevels.OnLand,
  TileSize = {1, 1}, BoxSize = {16, 16},
  SightRange = 1, ComputerReactionRange = 0, PersonReactionRange = 0,
  BasicDamage = 1, PiercingDamage = 1, Missile = "missile-none",
  MaxAttackRange = 0,
  Priority = 30,
  Points = 0,
  Type = "land",
  -- Damage and armor part
  IsBuildingArmor = 1,
  ----------------------
  CanTargetFlag = {"DeathMatchDoomer", "only"},
  Indestructible = 1,
  NonSolid = true,
  NumDirections = 1,
  CanAttack = true,
  IsNotSelectable = true,
  CanTargetLand = true,
  LandUnit = true,
  Item = true
} )

DefineAnimations("animations-deathmatch-shell-box", {
  Still = {"frame 0", "wait 4", "frame 0", "wait 1",},
  Attack = {"unbreakable begin",
	"frame 0", "set-var Op1.Value = 0",
	"if-var t_AmmoShells.Value == t_AmmoShells.Max full",
		"set-var AmmoShells.Value += 20 t",
		"goto end",
	"label full",
		"set-var Op1.Value = 1",
	"label end",
		"if-var v_Op1.Value == 1 notdie",
		"sound deathmatch-item-pickup",
		"lua-callback HandleDoomerMessages t_Slot.Value 4 v_Slot.Value",
		"frame 1", "set-var RespawnTime.Value = 900",	
		"label respawnloop",
		"frame 1", "set-var RespawnTime.Value -= 1",
		"wait 1",
		"if-var v_RespawnTime.Value != 0 respawnloop",
		"spawn-missile missile-deathmatch-item-teleport-fog 0 0 0 0 pixel", "sound deathmatch-item-respawn",
	"label notdie","unbreakable end", "wait 1",},
  Death = {"unbreakable begin","frame 0", "unbreakable end","wait 1",},
})

DefineUnitType("unit-deathmatch-shell-box", { Name = "Picked up a box of shotgun shells.",
  Image = {"file", "units/shell-box.png", "size", {24, 9}},
  Animations = "animations-deathmatch-shell-box", Icon = "icon-cancel",
  HitPoints = 15,
  DrawLevel = drawLevels.OnLand,
  TileSize = {1, 1}, BoxSize = {16, 16},
  SightRange = 1, ComputerReactionRange = 0, PersonReactionRange = 0,
  BasicDamage = 1, PiercingDamage = 1, Missile = "missile-none",
  MaxAttackRange = 0,
  Priority = 30,
  Points = 0,
  Type = "land",
  -- Damage and armor part
  IsBuildingArmor = 1,
  ----------------------
  CanTargetFlag = {"DeathMatchDoomer", "only"},
  Indestructible = 1,
  NonSolid = true,
  NumDirections = 1,
  CanAttack = true,
  IsNotSelectable = true,
  CanTargetLand = true,
  LandUnit = true,
  Item = true
} )

DefineAnimations("animations-deathmatch-rocket", {
  Still = {"frame 0", "wait 4", "frame 0", "wait 1",},
  Attack = {"unbreakable begin",
	"frame 0", "set-var Op1.Value = 0",
	"if-var t_AmmoRockets.Value == t_AmmoRockets.Max full",
		"set-var AmmoRockets.Value += 1 t",
		"goto end",
	"label full",
		"set-var Op1.Value = 1",
	"label end",
		"if-var v_Op1.Value == 1 notdie",
		"sound deathmatch-item-pickup",
		"lua-callback HandleDoomerMessages t_Slot.Value 4 v_Slot.Value",
		"frame 1", "set-var RespawnTime.Value = 900",	
		"label respawnloop",
		"frame 1", "set-var RespawnTime.Value -= 1",
		"wait 1",
		"if-var v_RespawnTime.Value != 0 respawnloop",
		"spawn-missile missile-deathmatch-item-teleport-fog 0 0 0 0 pixel", "sound deathmatch-item-respawn",
	"label notdie","unbreakable end", "wait 1",},
  Death = {"unbreakable begin","frame 0", "unbreakable end","wait 1",},
})

DefineUnitType("unit-deathmatch-rocket", { Name = "Picked up a rocket.",
  Image = {"file", "units/rocket.png", "size", {9, 20}},
  Animations = "animations-deathmatch-rocket", Icon = "icon-cancel",
  HitPoints = 15,
  DrawLevel = drawLevels.OnLand,
  TileSize = {1, 1}, BoxSize = {16, 16},
  SightRange = 1, ComputerReactionRange = 0, PersonReactionRange = 0,
  BasicDamage = 1, PiercingDamage = 1, Missile = "missile-none",
  MaxAttackRange = 0,
  Priority = 30,
  Points = 0,
  Type = "land",
  -- Damage and armor part
  IsBuildingArmor = 1,
  ----------------------
  CanTargetFlag = {"DeathMatchDoomer", "only"},
  Indestructible = 1,
  NonSolid = true,
  NumDirections = 1,
  CanAttack = true,
  IsNotSelectable = true,
  CanTargetLand = true,
  LandUnit = true,
  Item = true
} )

DefineAnimations("animations-deathmatch-rocket-box", {
  Still = {"frame 0", "wait 4", "frame 0", "wait 1",},
  Attack = {"unbreakable begin",
	"frame 0", "set-var Op1.Value = 0",
	"if-var t_AmmoRockets.Value == t_AmmoRockets.Max full",
		"set-var AmmoRockets.Value += 5 t",
		"goto end",
	"label full",
		"set-var Op1.Value = 1",
	"label end",
		"if-var v_Op1.Value == 1 notdie",
		"sound deathmatch-item-pickup",
		"lua-callback HandleDoomerMessages t_Slot.Value 4 v_Slot.Value",
		"frame 1", "set-var RespawnTime.Value = 900",	
		"label respawnloop",
		"frame 1", "set-var RespawnTime.Value -= 1",
		"wait 1",
		"if-var v_RespawnTime.Value != 0 respawnloop",
		"spawn-missile missile-deathmatch-item-teleport-fog 0 0 0 0 pixel", "sound deathmatch-item-respawn",
	"label notdie","unbreakable end", "wait 1",},
  Death = {"unbreakable begin","frame 0", "unbreakable end","wait 1",},
})

DefineUnitType("unit-deathmatch-rocket-box", { Name = "Picked up a box of rockets.",
  Image = {"file", "units/rocket-box.png", "size", {40, 16}},
  Animations = "animations-deathmatch-rocket-box", Icon = "icon-cancel",
  HitPoints = 15,
  DrawLevel = drawLevels.OnLand,
  TileSize = {1, 1}, BoxSize = {16, 16},
  SightRange = 1, ComputerReactionRange = 0, PersonReactionRange = 0,
  BasicDamage = 1, PiercingDamage = 1, Missile = "missile-none",
  MaxAttackRange = 0,
  Priority = 30,
  Points = 0,
  Type = "land",
  -- Damage and armor part
  IsBuildingArmor = 1,
  ----------------------
  CanTargetFlag = {"DeathMatchDoomer", "only"},
  Indestructible = 1,
  NonSolid = true,
  NumDirections = 1,
  CanAttack = true,
  IsNotSelectable = true,
  CanTargetLand = true,
  LandUnit = true,
  Item = true
} )

DefineAnimations("animations-deathmatch-energy-cell", {
  Still = {"frame 0", "wait 4", "frame 0", "wait 1",},
  Attack = {"unbreakable begin",
	"frame 0", "set-var Op1.Value = 0",
	"if-var t_AmmoCells.Value == t_AmmoCells.Max full",
		"set-var AmmoCells.Value += 20 t",
		"goto end",
	"label full",
		"set-var Op1.Value = 1",
	"label end",
		"if-var v_Op1.Value == 1 notdie",
		"sound deathmatch-item-pickup",
		"lua-callback HandleDoomerMessages t_Slot.Value 4 v_Slot.Value",
		"frame 1", "set-var RespawnTime.Value = 900",	
		"label respawnloop",
		"frame 1", "set-var RespawnTime.Value -= 1",
		"wait 1",
		"if-var v_RespawnTime.Value != 0 respawnloop",
		"spawn-missile missile-deathmatch-item-teleport-fog 0 0 0 0 pixel", "sound deathmatch-item-respawn",
	"label notdie","unbreakable end", "wait 1",},
  Death = {"unbreakable begin","frame 0", "unbreakable end","wait 1",},
})

DefineUnitType("unit-deathmatch-energy-cell", { Name = "Picked up an energy cell.",
  Image = {"file", "units/energy-cell.png", "size", {13, 9}},
  Animations = "animations-deathmatch-energy-cell", Icon = "icon-cancel",
  HitPoints = 15,
  DrawLevel = drawLevels.OnLand,
  TileSize = {1, 1}, BoxSize = {16, 16},
  SightRange = 1, ComputerReactionRange = 0, PersonReactionRange = 0,
  BasicDamage = 1, PiercingDamage = 1, Missile = "missile-none",
  MaxAttackRange = 0,
  Priority = 30,
  Points = 0,
  Type = "land",
  -- Damage and armor part
  IsBuildingArmor = 1,
  ----------------------
  CanTargetFlag = {"DeathMatchDoomer", "only"},
  Indestructible = 1,
  NonSolid = true,
  NumDirections = 1,
  CanAttack = true,
  IsNotSelectable = true,
  CanTargetLand = true,
  LandUnit = true,
  Item = true
} )

DefineAnimations("animations-deathmatch-cell-pack", {
  Still = {"frame 0", "wait 4", "frame 0", "wait 1",},
  Attack = {"unbreakable begin",
	"frame 0", "set-var Op1.Value = 0",
	"if-var t_AmmoCells.Value == t_AmmoCells.Max full",
		"set-var AmmoCells.Value += 100 t",
		"goto end",
	"label full",
		"set-var Op1.Value = 1",
	"label end",
		"if-var v_Op1.Value == 1 notdie",
		"sound deathmatch-item-pickup",
		"lua-callback HandleDoomerMessages t_Slot.Value 4 v_Slot.Value",
		"frame 1", "set-var RespawnTime.Value = 900",	
		"label respawnloop",
		"frame 1", "set-var RespawnTime.Value -= 1",
		"wait 1",
		"if-var v_RespawnTime.Value != 0 respawnloop",
		"spawn-missile missile-deathmatch-item-teleport-fog 0 0 0 0 pixel", "sound deathmatch-item-respawn",
	"label notdie","unbreakable end", "wait 1",},
  Death = {"unbreakable begin","frame 0", "unbreakable end","wait 1",},
})

DefineUnitType("unit-deathmatch-cell-pack", { Name = "Picked up an energy cell pack.",
  Image = {"file", "units/cell-pack.png", "size", {24, 16}},
  Animations = "animations-deathmatch-cell-pack", Icon = "icon-cancel",
  HitPoints = 15,
  DrawLevel = drawLevels.OnLand,
  TileSize = {1, 1}, BoxSize = {16, 16},
  SightRange = 1, ComputerReactionRange = 0, PersonReactionRange = 0,
  BasicDamage = 1, PiercingDamage = 1, Missile = "missile-none",
  MaxAttackRange = 0,
  Priority = 30,
  Points = 0,
  Type = "land",
  -- Damage and armor part
  IsBuildingArmor = 1,
  ----------------------
  CanTargetFlag = {"DeathMatchDoomer", "only"},
  Indestructible = 1,
  NonSolid = true,
  NumDirections = 1,
  CanAttack = true,
  IsNotSelectable = true,
  CanTargetLand = true,
  LandUnit = true,
  Item = true
} )

DefineAnimations("animations-deathmatch-backpack", {
  Still = {"frame 0", "wait 4", "frame 0", "wait 1",},
  Attack = {"unbreakable begin",
	"frame 0",
	"if-var t_HasBackpack.Value == 1 justfill",
		"set-var AmmoCells.Max = 600 t",
		"set-var AmmoRockets.Max = 100 t",
		"set-var AmmoShells.Max = 100 t",
		"set-var AmmoBullets.Max = 400 t",
		"set-var HasBackpack.Value = 1 t",
	"label justfill",
		"set-var AmmoCells.Value += 20 t",
		"set-var AmmoRockets.Value += 1 t",
		"set-var AmmoShells.Value += 4 t",
		"set-var AmmoBullets.Value += 10 t",
		"goto end",
	"label end",
		"if-var v_Op1.Value == 1 notdie",
		"sound deathmatch-item-pickup",
		"lua-callback HandleDoomerMessages t_Slot.Value 4 v_Slot.Value",
		"frame 1", "set-var RespawnTime.Value = 900",	
		"label respawnloop",
		"frame 1", "set-var RespawnTime.Value -= 1",
		"wait 1",
		"if-var v_RespawnTime.Value != 0 respawnloop",
		"spawn-missile missile-deathmatch-item-teleport-fog 0 0 0 0 pixel", "sound deathmatch-item-respawn",
	"label notdie","unbreakable end", "wait 1",},
  Death = {"unbreakable begin","frame 0", "unbreakable end","wait 1",},
})

DefineUnitType("unit-deathmatch-backpack", { Name = "Picked up a backpack full of ammo!",
  Image = {"file", "units/backpack.png", "size", {16, 21}},
  Animations = "animations-deathmatch-backpack", Icon = "icon-cancel",
  HitPoints = 15,
  DrawLevel = drawLevels.OnLand,
  TileSize = {1, 1}, BoxSize = {16, 16},
  SightRange = 1, ComputerReactionRange = 0, PersonReactionRange = 0,
  BasicDamage = 1, PiercingDamage = 1, Missile = "missile-none",
  MaxAttackRange = 0,
  Priority = 30,
  Points = 0,
  Type = "land",
  -- Damage and armor part
  IsBuildingArmor = 1,
  ----------------------
  CanTargetFlag = {"DeathMatchDoomer", "only"},
  Indestructible = 1,
  NonSolid = true,
  NumDirections = 1,
  CanAttack = true,
  IsNotSelectable = true,
  CanTargetLand = true,
  LandUnit = true,
  Item = true
} )

-- Armor
DefineAnimations("animations-deathmatch-green-armor", {
  Still = {"frame 0", "wait 4", "frame 1", "wait 3", "frame 1", "wait 1",},
  Attack = {"unbreakable begin",
	"frame 0", "set-var Op1.Value = 0",
	"if-var t_ShieldPoints.Value >= 100 full",
		"set-var ShieldPoints.Value = 100 t",
		"set-var ShieldPermeability.Value = 67 t",
		"goto end",
	"label full",
		"set-var Op1.Value = 1",
	"label end",
		"if-var v_Op1.Value == 1 notdie",
		"sound deathmatch-item-pickup",
		"lua-callback HandleDoomerMessages t_Slot.Value 4 v_Slot.Value",
		"frame 2", "set-var RespawnTime.Value = 1800",	
		"label respawnloop",
		"frame 2", "set-var RespawnTime.Value -= 1",
		"wait 1",
		"if-var v_RespawnTime.Value != 0 respawnloop",
		"spawn-missile missile-deathmatch-item-teleport-fog 0 0 0 0 pixel", "sound deathmatch-item-respawn",
	"label notdie","unbreakable end", "wait 1",},
  Death = {"unbreakable begin","frame 0", "unbreakable end","wait 1",},
})

DefineUnitType("unit-deathmatch-green-armor", { Name = "Picked up the armor.",
  Image = {"file", "units/green-armor.png", "size", {23, 13}},
  Animations = "animations-deathmatch-green-armor", Icon = "icon-cancel",
  HitPoints = 15,
  DrawLevel = drawLevels.OnLand,
  TileSize = {1, 1}, BoxSize = {16, 16},
  SightRange = 1, ComputerReactionRange = 0, PersonReactionRange = 0,
  BasicDamage = 1, PiercingDamage = 1, Missile = "missile-none",
  MaxAttackRange = 0,
  Priority = 30,
  Points = 0,
  Type = "land",
  -- Damage and armor part
  IsBuildingArmor = 1,
  ----------------------
  CanTargetFlag = {"DeathMatchDoomer", "only"},
  Indestructible = 1,
  NonSolid = true,
  NumDirections = 1,
  CanAttack = true,
  IsNotSelectable = true,
  CanTargetLand = true,
  LandUnit = true,
  Item = true
} )

DefineAnimations("animations-deathmatch-blue-armor", {
  Still = {"frame 0", "wait 4", "frame 1", "wait 3", "frame 1", "wait 1",},
  Attack = {"unbreakable begin",
	"frame 0", "set-var Op1.Value = 0",
	"if-var t_ShieldPoints.Value >= t_ShieldPoints.Max full",
		"set-var ShieldPoints.Value = 200 t",
		"set-var ShieldPermeability.Value = 50 t",
		"goto end",
	"label full",
		"set-var Op1.Value = 1",
	"label end",
		"if-var v_Op1.Value == 1 notdie",
		"sound deathmatch-item-pickup",
		"lua-callback HandleDoomerMessages t_Slot.Value 4 v_Slot.Value",
		"frame 2", "set-var RespawnTime.Value = 1800",	
		"label respawnloop",
		"frame 2", "set-var RespawnTime.Value -= 1",
		"wait 1",
		"if-var v_RespawnTime.Value != 0 respawnloop",
		"spawn-missile missile-deathmatch-item-teleport-fog 0 0 0 0 pixel", "sound deathmatch-item-respawn",
	"label notdie","unbreakable end", "wait 1",},
  Death = {"unbreakable begin","frame 0", "unbreakable end","wait 1",},
})

DefineUnitType("unit-deathmatch-blue-armor", { Name = "Picked up the MegaArmor!",
  Image = {"file", "units/blue-armor.png", "size", {24, 13}},
  Animations = "animations-deathmatch-blue-armor", Icon = "icon-cancel",
  HitPoints = 15,
  DrawLevel = drawLevels.OnLand,
  TileSize = {1, 1}, BoxSize = {16, 16},
  SightRange = 1, ComputerReactionRange = 0, PersonReactionRange = 0,
  BasicDamage = 1, PiercingDamage = 1, Missile = "missile-none",
  MaxAttackRange = 0,
  Priority = 30,
  Points = 0,
  Type = "land",
  -- Damage and armor part
  IsBuildingArmor = 1,
  ----------------------
  CanTargetFlag = {"DeathMatchDoomer", "only"},
  Indestructible = 1,
  NonSolid = true,
  NumDirections = 1,
  CanAttack = true,
  IsNotSelectable = true,
  CanTargetLand = true,
  LandUnit = true,
  Item = true
} )

DefineAnimations("animations-deathmatch-armor-bonus", {
  Still = {"frame 0", "wait 4", "frame 1", "wait 4", "frame 2", "wait 4", "frame 3","wait 4", 
  "frame 2", "wait 4", "frame 1", "wait 3","frame 1", "wait 1",},
  Attack = {"unbreakable begin",
	"frame 0", "set-var Op1.Value = 0",
		"set-var ShieldPoints.Value += 1 t",
		"if-var t_ShieldPermeability.Value == 50 end",
		"set-var ShieldPermeability.Value = 67 t",
		"goto end",
	"label end",
		"sound deathmatch-item-pickup",
		"lua-callback HandleDoomerMessages t_Slot.Value 4 v_Slot.Value",
		"frame 5", "set-var RespawnTime.Value = 1800",	
		"label respawnloop",
		"frame 5", "set-var RespawnTime.Value -= 1",
		"wait 1",
		"if-var v_RespawnTime.Value != 0 respawnloop",
		"spawn-missile missile-deathmatch-item-teleport-fog 0 0 0 0 pixel", "sound deathmatch-item-respawn",
	"label notdie","unbreakable end", "wait 1",},
  Death = {"unbreakable begin","frame 0", "unbreakable end","wait 1",},
})

DefineUnitType("unit-deathmatch-armor-bonus", { Name = "Picked up an armor bonus.",
  Image = {"file", "units/armor-bonus.png", "size", {12, 11}},
  Animations = "animations-deathmatch-armor-bonus", Icon = "icon-cancel",
  HitPoints = 15,
  DrawLevel = drawLevels.OnLand,
  TileSize = {1, 1}, BoxSize = {16, 16},
  SightRange = 1, ComputerReactionRange = 0, PersonReactionRange = 0,
  BasicDamage = 1, PiercingDamage = 1, Missile = "missile-none",
  MaxAttackRange = 0,
  Priority = 30,
  Points = 0,
  Type = "land",
  -- Damage and armor part
  IsBuildingArmor = 1,
  ----------------------
  CanTargetFlag = {"DeathMatchDoomer", "only"},
  Indestructible = 1,
  NonSolid = true,
  NumDirections = 1,
  CanAttack = true,
  IsNotSelectable = true,
  CanTargetLand = true,
  LandUnit = true,
  Item = true
} )

-- Health
DefineAnimations("animations-deathmatch-stimpack", {
  Still = {"frame 0", "wait 4", "frame 0", "wait 1",},
  Attack = {"unbreakable begin",
	"frame 0", "set-var Op1.Value = 0",
	"if-var t_HitPoints.Value >= 100 full",
	"if-var t_HitPoints.Value >= 90 fillfull",
		"set-var HitPoints.Value += 10 t",
		"goto end",
	"label fillfull",
		"set-var HitPoints.Value = 100 t",
		"goto end",
	"label full",
		"set-var Op1.Value = 1",
	"label end",
		"if-var v_Op1.Value == 1 notdie",
		"sound deathmatch-item-pickup",
		"lua-callback HandleDoomerMessages t_Slot.Value 4 v_Slot.Value",
		"frame 1", "set-var RespawnTime.Value = 900",	
		"label respawnloop",
		"frame 1", "set-var RespawnTime.Value -= 1",
		"wait 1",
		"if-var v_RespawnTime.Value != 0 respawnloop",
		"spawn-missile missile-deathmatch-item-teleport-fog 0 0 0 0 pixel", "sound deathmatch-item-respawn",
	"label notdie",
	"unbreakable end", "wait 1",},
  Death = {"unbreakable begin","frame 0", "unbreakable end","wait 1",},
})

DefineUnitType("unit-deathmatch-stimpack", { Name = "Picked up a stimpack.",
  Image = {"file", "units/stimpack.png", "size", {10, 11}},
  Animations = "animations-deathmatch-stimpack", Icon = "icon-deathmatch-stimpack",
  HitPoints = 15,
  DrawLevel = drawLevels.OnLand,
  TileSize = {1, 1}, BoxSize = {16, 16},
  SightRange = 1, ComputerReactionRange = 0, PersonReactionRange = 0,
  BasicDamage = 1, PiercingDamage = 1, Missile = "missile-none",
  MaxAttackRange = 0,
  Priority = 30,
  Points = 0,
  Type = "land",
  -- Damage and armor part
  IsBuildingArmor = 1,
  ----------------------
  CanTargetFlag = {"DeathMatchDoomer", "only"},
  Indestructible = 1,
  NonSolid = true,
  NumDirections = 1,
  CanAttack = true,
  IsNotSelectable = true,
  CanTargetLand = true,
  LandUnit = true,
  Item = true
} )

DefineAnimations("animations-deathmatch-medikit", {
  Still = {"frame 0", "wait 4", "frame 0", "wait 1",},
  Attack = {"unbreakable begin",
	"frame 0", "set-var Op1.Value = 0",
	"if-var t_HitPoints.Value >= 100 full",
	"if-var t_HitPoints.Value >= 75 fillfull",
		"set-var HitPoints.Value += 25 t",
		"goto end",
	"label fillfull",
		"set-var HitPoints.Value = 100 t",
		"goto end",
	"label full",
		"set-var Op1.Value = 1",
	"label end",
		"if-var v_Op1.Value == 1 notdie",
		"sound deathmatch-item-pickup",
		"lua-callback HandleDoomerMessages t_Slot.Value 4 v_Slot.Value",
		"frame 1", "set-var RespawnTime.Value = 900",	
		"label respawnloop",
		"frame 1", "set-var RespawnTime.Value -= 1",
		"wait 1",
		"if-var v_RespawnTime.Value != 0 respawnloop",
		"spawn-missile missile-deathmatch-item-teleport-fog 0 0 0 0 pixel", "sound deathmatch-item-respawn",
	"label notdie","unbreakable end", "wait 1",},
  Death = {"unbreakable begin","frame 0", "unbreakable end","wait 1",},
})

DefineUnitType("unit-deathmatch-medikit", { Name = "Picked up a medikit.",
  Image = {"file", "units/medikit.png", "size", {21, 14}},
  Animations = "animations-deathmatch-medikit", Icon = "icon-deathmatch-medikit",
  HitPoints = 15,
  DrawLevel = drawLevels.OnLand,
  TileSize = {1, 1}, BoxSize = {16, 16},
  SightRange = 1, ComputerReactionRange = 0, PersonReactionRange = 0,
  BasicDamage = 1, PiercingDamage = 1, Missile = "missile-none",
  MaxAttackRange = 0,
  Priority = 30,
  Points = 0,
  Type = "land",
  -- Damage and armor part
  IsBuildingArmor = 1,
  ----------------------
  CanTargetFlag = {"DeathMatchDoomer", "only"},
  Indestructible = 1,
  NonSolid = true,
  NumDirections = 1,
  CanAttack = true,
  IsNotSelectable = true,
  CanTargetLand = true,
  LandUnit = true,
  Item = true
} )

DefineAnimations("animations-deathmatch-health-bonus", {
  Still = {"frame 0", "wait 4", "frame 1", "wait 4", "frame 2", "wait 4", "frame 3","wait 4", 
  "frame 2", "wait 4", "frame 1", "wait 3","frame 1", "wait 1",},
  Attack = {"unbreakable begin",
	"frame 0", "set-var Op1.Value = 0",
		"set-var HitPoints.Value += 1 t",
		"goto end",
	"label end",
		"sound deathmatch-item-pickup",
		"lua-callback HandleDoomerMessages t_Slot.Value 4 v_Slot.Value",
		"frame 5", "set-var RespawnTime.Value = 900",	
		"label respawnloop",
		"frame 5", "set-var RespawnTime.Value -= 1",
		"wait 1",
		"if-var v_RespawnTime.Value != 0 respawnloop",
		"spawn-missile missile-deathmatch-item-teleport-fog 0 0 0 0 pixel", "sound deathmatch-item-respawn",
	"label notdie","unbreakable end", "wait 1",},
  Death = {"unbreakable begin","frame 0", "unbreakable end","wait 1",},
})

DefineUnitType("unit-deathmatch-health-bonus", { Name = "Picked up a health bonus.",
  Image = {"file", "units/health-bonus.png", "size", {11, 14}},
  Animations = "animations-deathmatch-health-bonus", Icon = "icon-cancel",
  HitPoints = 15,
  DrawLevel = drawLevels.OnLand,
  TileSize = {1, 1}, BoxSize = {16, 16},
  SightRange = 1, ComputerReactionRange = 0, PersonReactionRange = 0,
  BasicDamage = 1, PiercingDamage = 1, Missile = "missile-none",
  MaxAttackRange = 0,
  Priority = 30,
  Points = 0,
  Type = "land",
  -- Damage and armor part
  IsBuildingArmor = 1,
  ----------------------
  CanTargetFlag = {"DeathMatchDoomer", "only"},
  Indestructible = 1,
  NonSolid = true,
  NumDirections = 1,
  CanAttack = true,
  IsNotSelectable = true,
  CanTargetLand = true,
  LandUnit = true,
  Item = true
} )

-- Power-ups

DefineAnimations("animations-deathmatch-soulsphere", {
  Still = {"frame 0", "wait 4", "frame 1", "wait 4", "frame 2", "wait 4", "frame 3","wait 3", "frame 3", "wait 1",},
  Attack = {"unbreakable begin",
	"frame 0", "set-var Op1.Value = 0",
		"set-var HitPoints.Value += 100 t",
		"goto end",
	"label end",
		"sound invilerability",
		"lua-callback HandleDoomerMessages t_Slot.Value 4 v_Slot.Value",
		"frame 5", "set-var RespawnTime.Value = 1800",
		"label respawnloop",
		"frame 5", "set-var RespawnTime.Value -= 1",
		"wait 1",
		"if-var v_RespawnTime.Value != 0 respawnloop",
		"spawn-missile missile-deathmatch-item-teleport-fog 0 0 0 0 pixel", "sound deathmatch-item-respawn",
	"label notdie","unbreakable end", "wait 1",},
  Death = {"unbreakable begin","frame 0", "unbreakable end","wait 1",},
})

DefineUnitType("unit-deathmatch-soulsphere", { Name = "Supercharge!",
  Image = {"file", "units/soulsphere.png", "size", {19, 19}},
  Animations = "animations-deathmatch-soulsphere", Icon = "icon-cancel",
  HitPoints = 15,
  DrawLevel = drawLevels.OnLand,
  TileSize = {1, 1}, BoxSize = {16, 16},
  SightRange = 1, ComputerReactionRange = 0, PersonReactionRange = 0,
  BasicDamage = 1, PiercingDamage = 1, Missile = "missile-none",
  MaxAttackRange = 0,
  Priority = 30,
  Points = 0,
  Type = "land",
  -- Damage and armor part
  IsBuildingArmor = 1,
  ----------------------
  CanTargetFlag = {"DeathMatchDoomer", "only"},
  Indestructible = 1,
  NonSolid = true,
  NumDirections = 1,
  CanAttack = true,
  IsNotSelectable = true,
  CanTargetLand = true,
  LandUnit = true,
  Item = true
} )

DefineAnimations("animations-deathmatch-berserk", {
  Still = {"frame 0", "wait 4", "frame 0", "wait 1",},
  Attack = {"unbreakable begin",
	"frame 0", "set-var Op1.Value = 0",
		"set-var BerserkTime.Value = 1800 t",
	"if-var t_HitPoints.Value >= 100 end",
	"set-var HitPoints.Value = 100 t",
		"goto end",
	"label end",
		"sound invilerability",
		"lua-callback HandleDoomerMessages t_Slot.Value 4 v_Slot.Value",
		"frame 1", "set-var RespawnTime.Value = 1800",	
		"label respawnloop",
		"frame 1", "set-var RespawnTime.Value -= 1",
		"wait 1",
		"if-var v_RespawnTime.Value != 0 respawnloop",
		"spawn-missile missile-deathmatch-item-teleport-fog 0 0 0 0 pixel", "sound deathmatch-item-respawn",
	"label notdie","unbreakable end", "wait 1",},
  Death = {"unbreakable begin","frame 0", "unbreakable end","wait 1",},
})

DefineUnitType("unit-deathmatch-berserk", { Name = "Berserk!",
  Image = {"file", "units/berserk.png", "size", {21, 14}},
  Animations = "animations-deathmatch-berserk", Icon = "icon-cancel",
  HitPoints = 15,
  DrawLevel = drawLevels.OnLand,
  TileSize = {1, 1}, BoxSize = {16, 16},
  SightRange = 1, ComputerReactionRange = 0, PersonReactionRange = 0,
  BasicDamage = 1, PiercingDamage = 1, Missile = "missile-none",
  MaxAttackRange = 0,
  Priority = 30,
  Points = 0,
  Type = "land",
  -- Damage and armor part
  IsBuildingArmor = 1,
  ----------------------
  CanTargetFlag = {"DeathMatchDoomer", "only"},
  Indestructible = 1,
  NonSolid = true,
  NumDirections = 1,
  CanAttack = true,
  IsNotSelectable = true,
  CanTargetLand = true,
  LandUnit = true,
  Item = true
} )
--[[
DefineAnimations("animations-deathmatch-invisibility", {
  Still = {"frame 0", "wait 4", "frame 1", "wait 4", "frame 2", "wait 4", "frame 3","wait 3", "frame 3", "wait 1",},
  Attack = {"unbreakable begin",
	"frame 0", "set-var Op1.Value = 0",
		"set-var InvisTime.Value = 900 t",
		"goto end",
	"label end",
		"sound invilerability",
		"lua-callback HandleDoomerMessages t_Slot.Value 4 v_Slot.Value",
		"frame 5", "set-var RespawnTime.Value = 3600",	
		"label respawnloop",
		"frame 5", "set-var RespawnTime.Value -= 1",
		"wait 1",
		"if-var v_RespawnTime.Value != 0 respawnloop",
		"spawn-missile missile-deathmatch-item-teleport-fog 0 0 0 0 pixel", "sound deathmatch-item-respawn",
	"label notdie","unbreakable end", "wait 1",},
  Death = {"unbreakable begin","frame 0", "unbreakable end","wait 1",},
})

DefineUnitType("unit-deathmatch-invisibility", { Name = "Partial invisibility",
  Image = {"file", "units/invisibility.png", "size", {19, 19}},
  Animations = "animations-deathmatch-invisibility", Icon = "icon-cancel",
  HitPoints = 15,
  DrawLevel = drawLevels.OnLand,
  TileSize = {1, 1}, BoxSize = {16, 16},
  SightRange = 1, ComputerReactionRange = 0, PersonReactionRange = 0,
  BasicDamage = 1, PiercingDamage = 1, Missile = "missile-none",
  MaxAttackRange = 0,
  Priority = 30,
  Points = 0,
  Type = "land",
  -- Damage and armor part
  IsBuildingArmor = 1,
  ----------------------
  CanTargetFlag = {"DeathMatchDoomer", "only"},
  Indestructible = 1,
  NonSolid = true,
  NumDirections = 1,
  CanAttack = true,
  IsNotSelectable = true,
  CanTargetLand = true,
  LandUnit = true,
  Item = true
} )]]
--[[
DefineAnimations("animations-deathmatch-invulnerability", {
  Still = {"frame 0", "wait 4", "frame 1", "wait 4", "frame 2", "wait 4", "frame 3","wait 3", "frame 3", "wait 1",},
  Attack = {"unbreakable begin",
	"frame 0", "set-var Op1.Value = 0",
		"set-var UnholyArmor.Max = 900 t",
		"set-var UnholyArmor.Value = 900 t",
		"goto end",
	"label end",
		"sound invilerability",
		"lua-callback HandleDoomerMessages t_Slot.Value 4 v_Slot.Value",
		"frame 5", "set-var RespawnTime.Value = 3600",	
		"label respawnloop",
		"frame 5", "set-var RespawnTime.Value -= 1",
		"wait 1",
		"if-var v_RespawnTime.Value != 0 respawnloop",
		"spawn-missile missile-deathmatch-item-teleport-fog 0 0 0 0 pixel", "sound deathmatch-item-respawn",
	"label notdie","unbreakable end", "wait 1",},
  Death = {"unbreakable begin","frame 0", "unbreakable end","wait 1",},
})

DefineUnitType("unit-deathmatch-invulnerability", { Name = "Invulnerability!",
  Image = {"file", "units/invulerability.png", "size", {19, 19}},
  Animations = "animations-deathmatch-invulnerability", Icon = "icon-cancel",
  HitPoints = 15,
  DrawLevel = drawLevels.OnLand,
  TileSize = {1, 1}, BoxSize = {16, 16},
  SightRange = 1, ComputerReactionRange = 0, PersonReactionRange = 0,
  BasicDamage = 1, PiercingDamage = 1, Missile = "missile-none",
  MaxAttackRange = 0,
  Priority = 30,
  Points = 0,
  Type = "land",
  -- Damage and armor part
  IsBuildingArmor = 1,
  ----------------------
  CanTargetFlag = {"DeathMatchDoomer", "only"},
  Indestructible = 1,
  NonSolid = true,
  NumDirections = 1,
  CanAttack = true,
  IsNotSelectable = true,
  CanTargetLand = true,
  LandUnit = true,
  Item = true
} )
]]
DefineAnimations("animations-deathmatch-megasphere", {
  Still = {"frame 0", "wait 4", "frame 1", "wait 4", "frame 2", "wait 4", "frame 3","wait 3", "frame 3", "wait 1",},
  Attack = {"unbreakable begin",
	"frame 0", "set-var Op1.Value = 0",
		"set-var HitPoints.Value = 200 t",
		"set-var ShieldPoints.Value = 200 t",
		"set-var ShieldPermeability.Value = 50 t",
		"goto end",
	"label end",
		"sound invilerability",
		"lua-callback HandleDoomerMessages t_Slot.Value 4 v_Slot.Value",
		"frame 5", "set-var RespawnTime.Value = 3600",	
		"label respawnloop",
		"frame 5", "set-var RespawnTime.Value -= 1",
		"wait 1",
		"if-var v_RespawnTime.Value != 0 respawnloop",
		"spawn-missile missile-deathmatch-item-teleport-fog 0 0 0 0 pixel", "sound deathmatch-item-respawn",
	"label notdie","unbreakable end", "wait 1",},
  Death = {"unbreakable begin","frame 0", "unbreakable end","wait 1",},
})

DefineUnitType("unit-deathmatch-megasphere", { Name = "Megasphere!",
  Image = {"file", "units/megasphere.png", "size", {19, 19}},
  Animations = "animations-deathmatch-megasphere", Icon = "icon-cancel",
  HitPoints = 15,
  DrawLevel = drawLevels.OnLand,
  TileSize = {1, 1}, BoxSize = {16, 16},
  SightRange = 1, ComputerReactionRange = 0, PersonReactionRange = 0,
  BasicDamage = 1, PiercingDamage = 1, Missile = "missile-none",
  MaxAttackRange = 0,
  Priority = 30,
  Points = 0,
  Type = "land",
  -- Damage and armor part
  IsBuildingArmor = 1,
  ----------------------
  CanTargetFlag = {"DeathMatchDoomer", "only"},
  Indestructible = 1,
  NonSolid = true,
  NumDirections = 1,
  CanAttack = true,
  IsNotSelectable = true,
  CanTargetLand = true,
  LandUnit = true,
  Item = true
} )
--[[
function DeathMatchComputerMap()
	RevealMap()
	SetFogOfWar(false)
end

DefineAnimations("animations-deathmatch-computermap", {
  Still = {"frame 0", "wait 4", "frame 1", "wait 4", "frame 2", "wait 4", "frame 3","wait 3", "frame 3", "wait 1",},
  Attack = {"unbreakable begin",
	"frame 0", "set-var Op1.Value = 0",
		"if-var v_HasComputerMap.Value == 1 notdie",
		"lua-callback DeathMatchComputerMap",
		"set-var HasComputerMap.Value = 1 t",
		"goto end",
	"label end",
		"sound invilerability",
		"lua-callback HandleDoomerMessages t_Slot.Value 4 v_Slot.Value",
		"frame 5", "set-var RespawnTime.Value = 1800",	
		"label respawnloop",
		"frame 5", "set-var RespawnTime.Value -= 1",
		"wait 1",
		"if-var v_RespawnTime.Value != 0 respawnloop",
		"spawn-missile missile-deathmatch-item-teleport-fog 0 0 0 0 pixel", "sound deathmatch-item-respawn",
	"label notdie","unbreakable end", "wait 1",},
  Death = {"unbreakable begin","frame 0", "unbreakable end","wait 1",},
})

DefineUnitType("unit-deathmatch-computermap", { Name = "Computer Area Map",
  Image = {"file", "units/computer-map.png", "size", {22, 21}},
  Animations = "animations-deathmatch-computermap", Icon = "icon-cancel",
  HitPoints = 15,
  DrawLevel = drawLevels.OnLand,
  TileSize = {1, 1}, BoxSize = {16, 16},
  SightRange = 1, ComputerReactionRange = 0, PersonReactionRange = 0,
  BasicDamage = 1, PiercingDamage = 1, Missile = "missile-none",
  MaxAttackRange = 0,
  Priority = 30,
  Points = 0,
  Type = "land",
  -- Damage and armor part
  IsBuildingArmor = 1,
  ----------------------
  CanTargetFlag = {"DeathMatchDoomer", "only"},
  Indestructible = 1,
  NonSolid = true,
  NumDirections = 1,
  CanAttack = true,
  IsNotSelectable = true,
  CanTargetLand = true,
  LandUnit = true,
  Item = true
} )]]

function DeathMatchSelectNewWeapon(weapon, slot)
	local player = GetUnitVariable(slot, "Player")
	if (GetPlayerData(player, "AiEnabled") == true) then
		local ident = GetUnitVariable(weapon, "Ident")
		if (ident == "unit-deathmatch-chainsaw") then
			SetUnitVariable(slot, "Weapon", 1, "Value")
		elseif (ident == "unit-deathmatch-shotgun") then
			SetUnitVariable(slot, "Weapon", 3, "Value")
		elseif (ident == "unit-deathmatch-ssg") then
			SetUnitVariable(slot, "Weapon", 4, "Value")
		elseif (ident == "unit-deathmatch-chaingun") then
			SetUnitVariable(slot, "Weapon", 5, "Value")
		elseif (ident == "unit-deathmatch-rl") then
			SetUnitVariable(slot, "Weapon", 6, "Value")
		elseif (ident == "unit-deathmatch-plasma-rifle") then
			SetUnitVariable(slot, "Weapon", 7, "Value")
		elseif (ident == "unit-deathmatch-bfg9000") then
			SetUnitVariable(slot, "Weapon", 8, "Value")
		end
	end
end

DefineAnimations("animations-deathmatch-chainsaw", {
  Still = {"frame 0", "wait 4", "frame 0", "wait 1",},
  Attack = {"unbreakable begin",
	"frame 0",
	"if-var t_HasChainsaw.Value == 1 notdie",
		"set-var HasChainsaw.Value = 1 t",
		"goto end",
	"label end",
		"lua-callback DeathMatchSelectNewWeapon v_Slot.Value t_Slot.Value",
		"sound deathmatch-weapon-pickup",
		"lua-callback HandleDoomerMessages t_Slot.Value 4 v_Slot.Value",
		"frame 1", "set-var RespawnTime.Value = 900",	
		"label respawnloop",
		"frame 1", "set-var RespawnTime.Value -= 1",
		"wait 1",
		"if-var v_RespawnTime.Value != 0 respawnloop",
		"spawn-missile missile-deathmatch-item-teleport-fog 0 0 0 0 pixel", "sound deathmatch-item-respawn",
	"label notdie","unbreakable end", "wait 1",},
  Death = {"unbreakable begin","frame 0", "unbreakable end","wait 1",},
})

DefineUnitType("unit-deathmatch-chainsaw", { Name = "A chainsaw!  Find some meat!",
  Image = {"file", "units/chainsaw.png", "size", {46, 18}},
  Animations = "animations-deathmatch-chainsaw", Icon = "icon-cancel",
  HitPoints = 15,
  DrawLevel = drawLevels.OnLand,
  TileSize = {1, 1}, BoxSize = {16, 16},
  SightRange = 1, ComputerReactionRange = 0, PersonReactionRange = 0,
  BasicDamage = 1, PiercingDamage = 1, Missile = "missile-none",
  MaxAttackRange = 0,
  Priority = 30,
  Points = 0,
  Type = "land",
  -- Damage and armor part
  IsBuildingArmor = 1,
  ----------------------
  CanTargetFlag = {"DeathMatchDoomer", "only"},
  Indestructible = 1,
  NonSolid = true,
  NumDirections = 1,
  CanAttack = true,
  IsNotSelectable = true,
  CanTargetLand = true,
  LandUnit = true,
  Item = true
} )

DefineAnimations("animations-deathmatch-shotgun", {
  Still = {"frame 0", "wait 4", "frame 0", "wait 1",},
  Attack = {"unbreakable begin",
	"frame 0",
	"if-var t_HasShotgun.Value == 0 pickupweap",
	"if-var t_AmmoShells.Value < t_AmmoShells.Max pickupammo",
		"goto notdie",
	"label pickupweap",
		"set-var HasShotgun.Value = 1 t",
	"label pickupammo",
		"set-var AmmoShells.Value += 8 t",
	"label end",
		"lua-callback DeathMatchSelectNewWeapon v_Slot.Value t_Slot.Value",
		"sound deathmatch-weapon-pickup",
		"lua-callback HandleDoomerMessages t_Slot.Value 4 v_Slot.Value",
		"frame 1", "set-var RespawnTime.Value = 900",	
		"label respawnloop",
		"frame 1", "set-var RespawnTime.Value -= 1",
		"wait 1",
		"if-var v_RespawnTime.Value != 0 respawnloop",
		"spawn-missile missile-deathmatch-item-teleport-fog 0 0 0 0 pixel", "sound deathmatch-item-respawn",
	"label notdie","unbreakable end", "wait 1",},
  Death = {"unbreakable begin","frame 0", "unbreakable end","wait 1",},
})

DefineUnitType("unit-deathmatch-shotgun", { Name = "You got the shotgun!",
  Image = {"file", "units/shotgun.png", "size", {47, 9}},
  Animations = "animations-deathmatch-shotgun", Icon = "icon-cancel",
  HitPoints = 15,
  DrawLevel = drawLevels.OnLand,
  TileSize = {1, 1}, BoxSize = {16, 16},
  SightRange = 1, ComputerReactionRange = 0, PersonReactionRange = 0,
  BasicDamage = 1, PiercingDamage = 1, Missile = "missile-none",
  MaxAttackRange = 0,
  Priority = 30,
  Points = 0,
  Type = "land",
  -- Damage and armor part
  IsBuildingArmor = 1,
  ----------------------
  CanTargetFlag = {"DeathMatchDoomer", "only"},
  Indestructible = 1,
  NonSolid = true,
  NumDirections = 1,
  CanAttack = true,
  IsNotSelectable = true,
  CanTargetLand = true,
  LandUnit = true,
  Item = true
} )

DefineAnimations("animations-deathmatch-ssg", {
  Still = {"frame 0", "wait 4", "frame 0", "wait 1",},
  Attack = {"unbreakable begin",
	"frame 0",
	"if-var t_HasSSG.Value == 0 pickupweap",
	"if-var t_AmmoShells.Value < t_AmmoShells.Max pickupammo",
		"goto notdie",
	"label pickupweap",
		"set-var HasSSG.Value = 1 t",
	"label pickupammo",
		"set-var AmmoShells.Value += 8 t",
	"label end",
		"lua-callback DeathMatchSelectNewWeapon v_Slot.Value t_Slot.Value",
		"sound deathmatch-weapon-pickup",
		"lua-callback HandleDoomerMessages t_Slot.Value 4 v_Slot.Value",
		"frame 1", "set-var RespawnTime.Value = 900",	
		"label respawnloop",
		"frame 1", "set-var RespawnTime.Value -= 1",
		"wait 1",
		"if-var v_RespawnTime.Value != 0 respawnloop",
		"spawn-missile missile-deathmatch-item-teleport-fog 0 0 0 0 pixel", "sound deathmatch-item-respawn",
	"label notdie","unbreakable end", "wait 1",},
  Death = {"unbreakable begin","frame 0", "unbreakable end","wait 1",},
})

DefineUnitType("unit-deathmatch-ssg", { Name = "You got the super shotgun!",
  Image = {"file", "units/ssg.png", "size", {44, 11}},
  Animations = "animations-deathmatch-ssg", Icon = "icon-cancel",
  HitPoints = 15,
  DrawLevel = drawLevels.OnLand,
  TileSize = {1, 1}, BoxSize = {16, 16},
  SightRange = 1, ComputerReactionRange = 0, PersonReactionRange = 0,
  BasicDamage = 1, PiercingDamage = 1, Missile = "missile-none",
  MaxAttackRange = 0,
  Priority = 30,
  Points = 0,
  Type = "land",
  -- Damage and armor part
  IsBuildingArmor = 1,
  ----------------------
  CanTargetFlag = {"DeathMatchDoomer", "only"},
  Indestructible = 1,
  NonSolid = true,
  NumDirections = 1,
  CanAttack = true,
  IsNotSelectable = true,
  CanTargetLand = true,
  LandUnit = true,
  Item = true
} )

DefineAnimations("animations-deathmatch-chaingun", {
  Still = {"frame 0", "wait 4", "frame 0", "wait 1",},
  Attack = {"unbreakable begin",
	"frame 0",
	"if-var t_HasChaingun.Value == 0 pickupweap",
	"if-var t_AmmoBullets.Value < t_AmmoBullets.Max pickupammo",
		"goto notdie",
	"label pickupweap",
		"set-var HasChaingun.Value = 1 t",
	"label pickupammo",
		"set-var AmmoBullets.Value += 20 t",
	"label end",
		"lua-callback DeathMatchSelectNewWeapon v_Slot.Value t_Slot.Value",
		"sound deathmatch-weapon-pickup",
		"lua-callback HandleDoomerMessages t_Slot.Value 4 v_Slot.Value",
		"frame 1", "set-var RespawnTime.Value = 900",	
		"label respawnloop",
		"frame 1", "set-var RespawnTime.Value -= 1",
		"wait 1",
		"if-var v_RespawnTime.Value != 0 respawnloop",
		"spawn-missile missile-deathmatch-item-teleport-fog 0 0 0 0 pixel", "sound deathmatch-item-respawn",
	"label notdie","unbreakable end", "wait 1",},
  Death = {"unbreakable begin","frame 0", "unbreakable end","wait 1",},
})

DefineUnitType("unit-deathmatch-chaingun", { Name = "You got the chaingun!",
  Image = {"file", "units/chaingun.png", "size", {40, 12}},
  Animations = "animations-deathmatch-chaingun", Icon = "icon-cancel",
  HitPoints = 15,
  DrawLevel = drawLevels.OnLand,
  TileSize = {1, 1}, BoxSize = {16, 16},
  SightRange = 1, ComputerReactionRange = 0, PersonReactionRange = 0,
  BasicDamage = 1, PiercingDamage = 1, Missile = "missile-none",
  MaxAttackRange = 0,
  Priority = 30,
  Points = 0,
  Type = "land",
  -- Damage and armor part
  IsBuildingArmor = 1,
  ----------------------
  CanTargetFlag = {"DeathMatchDoomer", "only"},
  Indestructible = 1,
  NonSolid = true,
  NumDirections = 1,
  CanAttack = true,
  IsNotSelectable = true,
  CanTargetLand = true,
  LandUnit = true,
  Item = true
} )

DefineAnimations("animations-deathmatch-rl", {
  Still = {"frame 0", "wait 4", "frame 0", "wait 1",},
  Attack = {"unbreakable begin",
	"frame 0",
	"if-var t_HasRL.Value == 0 pickupweap",
	"if-var t_AmmoRockets.Value < t_AmmoRockets.Max pickupammo",
		"goto notdie",
	"label pickupweap",
		"set-var HasRL.Value = 1 t",
	"label pickupammo",
		"set-var AmmoRockets.Value += 2 t",
	"label end",
		"lua-callback DeathMatchSelectNewWeapon v_Slot.Value t_Slot.Value",
		"sound deathmatch-weapon-pickup",
		"lua-callback HandleDoomerMessages t_Slot.Value 4 v_Slot.Value",
		"frame 1", "set-var RespawnTime.Value = 900",	
		"label respawnloop",
		"frame 1", "set-var RespawnTime.Value -= 1",
		"wait 1",
		"if-var v_RespawnTime.Value != 0 respawnloop",
		"spawn-missile missile-deathmatch-item-teleport-fog 0 0 0 0 pixel", "sound deathmatch-item-respawn",
	"label notdie","unbreakable end", "wait 1",},
  Death = {"unbreakable begin","frame 0", "unbreakable end","wait 1",},
})

DefineUnitType("unit-deathmatch-rl", { Name = "You got the rocket launcher!",
  Image = {"file", "units/rocket-launcher.png", "size", {46, 12}},
  Animations = "animations-deathmatch-rl", Icon = "icon-cancel",
  HitPoints = 15,
  DrawLevel = drawLevels.OnLand,
  TileSize = {1, 1}, BoxSize = {16, 16},
  SightRange = 1, ComputerReactionRange = 0, PersonReactionRange = 0,
  BasicDamage = 1, PiercingDamage = 1, Missile = "missile-none",
  MaxAttackRange = 0,
  Priority = 30,
  Points = 0,
  Type = "land",
  -- Damage and armor part
  IsBuildingArmor = 1,
  ----------------------
  CanTargetFlag = {"DeathMatchDoomer", "only"},
  Indestructible = 1,
  NonSolid = true,
  NumDirections = 1,
  CanAttack = true,
  IsNotSelectable = true,
  CanTargetLand = true,
  LandUnit = true,
  Item = true
} )

DefineAnimations("animations-deathmatch-plasma-rifle", {
  Still = {"frame 0", "wait 4", "frame 0", "wait 1",},
  Attack = {"unbreakable begin",
	"frame 0",
	"if-var t_HasPlasma.Value == 0 pickupweap",
	"if-var t_AmmoCells.Value < t_AmmoCells.Max pickupammo",
		"goto notdie",
	"label pickupweap",
		"set-var HasPlasma.Value = 1 t",
	"label pickupammo",
		"set-var AmmoCells.Value += 40 t",
	"label end",
		"lua-callback DeathMatchSelectNewWeapon v_Slot.Value t_Slot.Value",
		"sound deathmatch-weapon-pickup",
		"lua-callback HandleDoomerMessages t_Slot.Value 4 v_Slot.Value",
		"frame 1", "set-var RespawnTime.Value = 900",	
		"label respawnloop",
		"frame 1", "set-var RespawnTime.Value -= 1",
		"wait 1",
		"if-var v_RespawnTime.Value != 0 respawnloop",
		"spawn-missile missile-deathmatch-item-teleport-fog 0 0 0 0 pixel", "sound deathmatch-item-respawn",
	"label notdie","unbreakable end", "wait 1",},
  Death = {"unbreakable begin","frame 0", "unbreakable end","wait 1",},
})

DefineUnitType("unit-deathmatch-plasma-rifle", { Name = "You got the plasma gun!",
  Image = {"file", "units/plasma-gun.png", "size", {40, 12}},
  Animations = "animations-deathmatch-plasma-rifle", Icon = "icon-cancel",
  HitPoints = 15,
  DrawLevel = drawLevels.OnLand,
  TileSize = {1, 1}, BoxSize = {16, 16},
  SightRange = 1, ComputerReactionRange = 0, PersonReactionRange = 0,
  BasicDamage = 1, PiercingDamage = 1, Missile = "missile-none",
  MaxAttackRange = 0,
  Priority = 30,
  Points = 0,
  Type = "land",
  -- Damage and armor part
  IsBuildingArmor = 1,
  ----------------------
  CanTargetFlag = {"DeathMatchDoomer", "only"},
  Indestructible = 1,
  NonSolid = true,
  NumDirections = 1,
  CanAttack = true,
  IsNotSelectable = true,
  CanTargetLand = true,
  LandUnit = true,
  Item = true
} )

DefineAnimations("animations-deathmatch-bfg9000", {
  Still = {"frame 0", "wait 4", "frame 0", "wait 1",},
  Attack = {"unbreakable begin",
	"frame 0",
	"if-var t_HasBFG.Value == 0 pickupweap",
	"if-var t_AmmoCells.Value < t_AmmoCells.Max pickupammo",
		"goto notdie",
	"label pickupweap",
		"set-var HasBFG.Value = 1 t",
	"label pickupammo",
		"set-var AmmoCells.Value += 40 t",
	"label end",
		"lua-callback DeathMatchSelectNewWeapon v_Slot.Value t_Slot.Value",
		"sound deathmatch-weapon-pickup",
		"lua-callback HandleDoomerMessages t_Slot.Value 4 v_Slot.Value",
		"frame 1", "set-var RespawnTime.Value = 900",	
		"label respawnloop",
		"frame 1", "set-var RespawnTime.Value -= 1",
		"wait 1",
		"if-var v_RespawnTime.Value != 0 respawnloop",
		"spawn-missile missile-deathmatch-item-teleport-fog 0 0 0 0 pixel", "sound deathmatch-item-respawn",
	"label notdie","unbreakable end", "wait 1",},
  Death = {"unbreakable begin","frame 0", "unbreakable end","wait 1",},
})

DefineUnitType("unit-deathmatch-bfg9000", { Name = "You got the BFG9000!  Oh, yes.",
  Image = {"file", "units/bfg9000.png", "size", {46, 27}},
  Animations = "animations-deathmatch-bfg9000", Icon = "icon-cancel",
  HitPoints = 15,
  DrawLevel = drawLevels.OnLand,
  TileSize = {1, 1}, BoxSize = {16, 16},
  SightRange = 1, ComputerReactionRange = 0, PersonReactionRange = 0,
  BasicDamage = 1, PiercingDamage = 1, Missile = "missile-none",
  MaxAttackRange = 0,
  Priority = 30,
  Points = 0,
  Type = "land",
  -- Damage and armor part
  IsBuildingArmor = 1,
  ----------------------
  CanTargetFlag = {"DeathMatchDoomer", "only"},
  Indestructible = 1,
  NonSolid = true,
  NumDirections = 1,
  CanAttack = true,
  IsNotSelectable = true,
  CanTargetLand = true,
  LandUnit = true,
  Item = true
} )