-- Some variables to make calculations much easier
local UnitName
local BaseDamage = 0
local BaseDamage2 = 0
local BaseDamage3 = 0
local DamageType
local DamageType2
local DamageType3

DefineAnimations("animations-technician-mine", {
  Still = {"frame 0", "wait 4", "frame 0", "wait 1",},
  Attack = {"unbreakable begin",
	"frame 0", "wait 8", 
	"unbreakable end", "die", "wait 1",},
  Death = {"unbreakable begin","frame 0", "sound rocket explode","spawn-missile missile-mine-explode 0 0 0 0 damage", "wait 1", "unbreakable end","wait 1",},
})

DefineAnimations("animations-technician-bomb", {
  Still = {"frame 0", "wait 35", "sound bomb tick",
  "frame 1", "wait 35", "sound bomb tick",
  "frame 2", "wait 35", "sound bomb tick",
  "frame 3", "wait 35", "sound bomb tick",
  "frame 4", "wait 35", "sound bomb tick",
  "frame 5", "wait 35", "sound bomb tick",
  "frame 6", "wait 35", "sound bomb tick",
  "frame 7", "wait 35", "sound bomb tick",
  "frame 8", "wait 35", "sound bomb tick",
  "frame 9", "wait 35", "sound bomb tick",
  "frame 10", "wait 35", 
  "frame 10", "wait 1", "die selfkill", "wait 1"},
  Death_selfkill = {"unbreakable begin","frame 10", "sound building destroyed", "spawn-missile missile-charge-explode 0 0 0 0 damage", "wait 1", "unbreakable end","wait 1",},
  Death = {"unbreakable begin","frame 0", "wait 1", "unbreakable end","wait 1",},
})

local TechnicianStill = {
	"set-var Repair.Value = 0",
	"frame 5", "wait 4", "random-goto 99 no-rotate", 
	"frame 10", "wait 4",
	"frame 15", "wait 4",
	"frame 0", "wait 4","random-rotate 1", 
	"label no-rotate", "wait 1",}
local TechnicianMove = {"unbreakable begin",
	"set-var Repair.Value = 1",
	"frame 0", "if-var v_HitPoints.Percent <= 40 damaged50",
	"frame 0", "move 2", "wait 1", 
	"frame 0", "move 2", "wait 1", 
	"frame 5", "move 2", "wait 1", 
	"frame 5", "move 2", "wait 1",
    "frame 10", "move 2", "wait 1", 
	"frame 10", "move 2", "wait 1",
	"frame 15", "move 2", "wait 1", 
	"frame 15", "move 2", "wait 1",
    "frame 0", "move 2", "wait 1", 
	"frame 0", "move 2", "wait 1", 
	"frame 5", "move 2", "wait 1", 
	"frame 5", "move 2", "wait 1",
    "frame 10", "move 2", "wait 1", 
	"frame 10", "move 2", "wait 1",
	"frame 15", "move 2", "wait 1", 
	"frame 15", "move 2", "wait 1", "goto end",
	"label damaged50",
	"frame 0", "move 2", "wait 2", 
	"frame 0", "move 2", "wait 1", 
	"frame 5", "move 2", "wait 1", 
	"frame 5", "move 2", "wait 1",
    "frame 10", "move 2", "wait 2", 
	"frame 10", "move 2", "wait 1",
	"frame 15", "move 2", "wait 1", 
	"frame 15", "move 2", "wait 1",
    "frame 0", "move 2", "wait 2", 
	"frame 0", "move 2", "wait 1", 
	"frame 5", "move 2", "wait 1", 
	"frame 5", "move 2", "wait 1",
    "frame 10", "move 2", "wait 2", 
	"frame 10", "move 2", "wait 1",
	"frame 15", "move 2", "wait 1", 
	"frame 15", "move 2", "wait 1", 
	"label end","unbreakable end", "wait 1",}
local TechnicianDeath = {"unbreakable begin", 
	"frame 30", "spawn-missile missile-gibs 20 20 0 0 pixel", "wait 3", 
	"frame 35", "wait 3", 
	"frame 40", "wait 3", 
	"frame 45", "wait 3", 
	"frame 50", "wait 3", 
	"frame 55", "wait 3", 
	"frame 60", "spawn-unit unit-technician-body 0 0 2 15", "set-var RessurectPlayer.Value 0 l_this l",
	"if-var v_UsedSpheres.Value & "..marineSpheres.S_Skull.." skull",
	"if-var v_ZombificationTime.Value == 0 normal",
	"if-var v_VeteranOfPain.Value == 4 elite",
	"if-var r_100 >= 33 normal",
	"label elite",
	"set-var RessurectPlayer.Value 0 v_RessurectPlayerPain.Value l",
	"set-var Ressurect.Value 0 5 l",
	"goto normal",
	"label skull",
	"set-var UsedSpheres.Value += "..marineSpheres.S_Skull.." l",
	"label normal",
    "frame 60", "unbreakable end", "wait 1",}
local TechnicianDeathExtreme = {"unbreakable begin", 
	"frame 65", "spawn-missile missile-extreme-gibs 20 20 0 0 pixel", "spawn-missile missile-gibs 20 20 0 0 pixel", "wait 3", 
	"frame 70", "wait 3", 
	"frame 75", "wait 3", 
	"frame 80", "wait 3", 
	"frame 85", "wait 3", 
	"frame 90", "wait 3",
	"frame 95", "wait 3",
	"frame 100", "wait 3",
	"frame 105", "wait 2000",
    "frame 105", "unbreakable end", "wait 1",}

DefineAnimations("animations-technician-body", {
  Still = {"label begin","frame 60","if-var v_Arg1.Value > 0 still", "frame 60","wait 1", "goto end", 
  "label ressurect", 
  "spawn-unit unit-zombie-technician 0 0 2 v_RessurectPlayer.Value jointoai", "set-var RessurectPlayer.Value 0 v_RessurectPlayer.Value l", "set-var Ressurect.Value 0 2 l", "goto end",
  "label defibrillation",
  "spawn-unit unit-technician 0 0 2 v_RessurectPlayer.Value",
  "set-var HitPoints.Percent 0 30 l",
  "set-var ShieldPoints.Value == 0 l",
  "goto end",
  "label diedemon", "die demon_eating","wait 2",
  "label still","frame 60", "wait 1", 
  "if-var v_UnitFlags.Value & "..unitFlags.UF_KillFromDemon.." diedemon",
  "if-var v_Ressurect.Value >= 1 ressurect", 
  "if-var v_DoneDefibrillation.Value == 1 defibrillation",
  "set-var Arg1.Value 2 1","goto begin","label end","wait 1","die ressurect","wait 2"},
  Death_demon_eating = {"unbreakable begin","frame 60","spawn-missile missile-gibs 20 20 0 0 pixel","wait 3","unbreakable end","wait 1",},
  Death = {"unbreakable begin","frame 60","unbreakable end","wait 1",}
})

DefineAnimations("animations-technician", {
  Still = TechnicianStill,
  Move = TechnicianMove,
  Attack = {"unbreakable begin", 
	"set-var Repair.Value = 1",
	"frame 20", "wait 3", 
	"frame 25", "attack", "sound cyber launch", "wait 5", 
	"if-var v_Veterancy.Value != 4 normal",
	"frame 20", "wait 3", 
	"frame 25", "attack", "sound cyber launch", "wait 5",
	"label normal",
	"frame 20", "wait 12", 
	"unbreakable end", "wait 1",},
  SpellCast = {"unbreakable begin",
  "set-var Repair.Value = 1",
	"if-var s_spell-place-charge == 1 bomb",
	"if-var s_spell-technician-repair == 1 repair",
	"if-var s_spell-technician-armor-repair == 1 armorrepair",
	"frame 110", "wait 60",
	"goto next",
	"label bomb",
	"frame 115",  "wait 60",
	"goto next",
	"label repair",
	"frame 120", "rotate target", "attack", "spawn-missile missile-spark2 0 0 0 0 pixel 2", "wait 12",
	"goto end",
	"label armorrepair",
	"frame 120", "rotate target",
	"spawn-missile missile-spark2 0 0 0 0 pixel 2", "wait 12",
	"spawn-missile missile-spark2 0 0 0 0 pixel 2", "wait 12",
	"spawn-missile missile-spark2 0 0 0 0 pixel 2", "wait 12",
	"spawn-missile missile-spark2 0 0 0 0 pixel 2", "wait 12",
	"spawn-missile missile-spark2 0 0 0 0 pixel 2", "wait 12",
	"set-var Op1.Value = t_ShieldPoints.Value",
	"attack", 
	"if-var v_Op1.Value != t_ShieldPoints.Value take",
	"goto end",
	"label take",
	"sound repair armor",
	"set-player-var l_this Resources -= 40 minerals","goto end",
	"label next",
	"frame 20", "attack", "sound place mine",
	"wait 5",
	"label end",
	"unbreakable end", "wait 1",},
  Death = TechnicianDeath,
  Death_fire = {"unbreakable begin","frame 125","spawn-unit unit-burning 0 0 5 15","wait 100","unbreakable end","wait 1",},
  Death_extreme = TechnicianDeathExtreme
})

BaseDamage = 130
DamageType = "high-explosion"
DefineUnitType("unit-technician-mine", { Name = _("Mine"),
  Image = {"file", "graphics/uac/units/mine.png", "size", {16, 7}},
  Animations = "animations-technician-mine", Icon = "icon-cancel",
  Costs = {"time", 10, "minerals", 100},
  HitPoints = 15,
  DrawLevel = 5,
  TileSize = {1, 1}, BoxSize = {16, 16},
  SightRange = 5, ComputerReactionRange = 0, PersonReactionRange = 0,
  BasicDamage = 1, PiercingDamage = 1, Missile = "missile-none",
  MaxAttackRange = 0,
  Priority = 30,
  Points = 10,
  DamageType = "extreme",
  Type = "land",
  -- Damage and armor part
  IsBuildingArmor = 1,
  BaseDamage = BaseDamage,

  LightArmorDamage = GetArmorDamage(BaseDamage, DamageType, 1),
  CombatArmorDamage = GetArmorDamage(BaseDamage, DamageType, 2),
  HeavyArmorDamage = GetArmorDamage(BaseDamage, DamageType, 3),
  
  FleshArmorDamage = GetArmorDamage(BaseDamage, DamageType, 4),
  HeavyFleshArmorDamage = GetArmorDamage(BaseDamage, DamageType, 5),
  AirFleshArmorDamage = GetArmorDamage(BaseDamage, DamageType, 6),
  
  MechanicalArmorDamage = GetArmorDamage(BaseDamage, DamageType, 7),
  AirMechanicalArmorDamage = GetArmorDamage(BaseDamage, DamageType, 8),
  
  BuildingArmorDamage = 0,
  HeavyBuildingArmorDamage = 0,
  
  CursedArmorDamage = GetCursedDamage(BaseDamage),
  ----------------------
  DeathExplosion = TinyBuildingExplosion,
  UAC = true,
  CanTargetFlag = {"Building", "false"},
  NonSolid = true,
  PermanentCloak = true,
  DetectCloak = true,
  NumDirections = 1,
  CanAttack = true,
  IsNotSelectable = true,
  CanTargetLand = true,
  LandUnit = true
} )

BaseDamage = 1500
DamageType = "high-explosion"
DefineUnitType("unit-technician-bomb", { Name = _("Explosive charge"),
  Image = {"file", "graphics/uac/units/bomb.png", "size", {23, 32}},
  Animations = "animations-technician-bomb", Icon = "icon-cancel",
  Costs = {"time", 10, "minerals", 100},
  HitPoints = 30,
  DrawLevel = 5,
  TileSize = {1, 1}, BoxSize = {16, 16},
  SightRange = 1, ComputerReactionRange = 0, PersonReactionRange = 0,
  BasicDamage = 1, PiercingDamage = 1, Missile = "missile-none",
  MaxAttackRange = 0,
  Priority = 100,
  Points = 10,
  DamageType = "extreme",
  Type = "land",
  -- Damage and armor part
  IsHeavyBuildingArmor = 1,
  BaseDamage = BaseDamage,

  LightArmorDamage = GetArmorDamage(BaseDamage, DamageType, 1),
  CombatArmorDamage = GetArmorDamage(BaseDamage, DamageType, 2),
  HeavyArmorDamage = GetArmorDamage(BaseDamage, DamageType, 3),
  
  FleshArmorDamage = GetArmorDamage(BaseDamage, DamageType, 4),
  HeavyFleshArmorDamage = GetArmorDamage(BaseDamage, DamageType, 5),
  AirFleshArmorDamage = GetArmorDamage(BaseDamage, DamageType, 6),
  
  MechanicalArmorDamage = GetArmorDamage(BaseDamage, DamageType, 7),
  AirMechanicalArmorDamage = GetArmorDamage(BaseDamage, DamageType, 8),
  
  BuildingArmorDamage = GetArmorDamage(BaseDamage, DamageType, 9),
  HeavyBuildingArmorDamage = GetArmorDamage(BaseDamage, DamageType, 10),
  
  CursedArmorDamage = GetCursedDamage(BaseDamage),
  ----------------------
  DeathExplosion = SmallBuildingExplosion,
  UAC = true,
  Coward = true,
  CanTargetFlag = {"Building", "only"},
  NonSolid = true,
  NumDirections = 1,
  CanAttack = true,
  IsNotSelectable = true,
  CanTargetLand = true,
  LandUnit = true } )

UnitName = "unit-technician"
BaseDamage = UnitInfo(UnitName, const.Unit_BaseDmg)
DamageType = UnitInfo(UnitName, const.Unit_DamageType)
DefineUnitType(UnitName, { Name = _("Techician"),
  -- Drawing
  Image = {"file", "graphics/uac/units/technician.png", "size", {42, 42}},
  Shadow = {"file", "graphics/uac/units/technician-s.png", "size",{42, 42},"offset", {0, 0}},
  Animations = "animations-technician", Icon = "icon-technician",
  DrawLevel = UnitInfo(UnitName, const.Unit_Draw),
  TileSize = {1, 1}, BoxSize = {30, 45},
  Impact = {"shell", "missile-red-shell-meat", "melee", "missile-red-melee-meat"},
  MissileOffsets = {{{5, 0}, {5, -5}, {16, -2}, {16, -2}, {-12, -2}, {-16, -4}, {-20, -4}, {-16, -10}},
				{{20, 12}, {32, 12}, {30, 12}, {24, 14}, {20, 15}, {4, 16}, {-2, 14}, {0, 14}}},
  Flip = false, NumDirections = 8,
  Type = "land",
  -- Properties
  Costs = {"time", UnitInfo(UnitName, const.Unit_Build), "minerals", UnitInfo(UnitName, const.Unit_MinCost), "energy", UnitInfo(UnitName, const.Unit_EngCost)},
  HitPoints = UnitInfo(UnitName, const.Unit_HP),
  ShieldPoints = {Value = UnitInfo(UnitName, const.Unit_SP), Max = UnitInfo(UnitName, const.Unit_SP), Increase = 0, Enable = ShieldEnableControl(UnitInfo(UnitName, const.Unit_SP))},
  SightRange = UnitInfo(UnitName, const.Unit_Sight), ComputerReactionRange = UnitInfo(UnitName, const.Unit_Comp),
  PersonReactionRange = UnitInfo(UnitName, const.Unit_Person),
  MaxAttackRange = UnitInfo(UnitName, const.Unit_AtkRange),
  Priority = 30,
  ShieldPermeability = 50,
  Points = UnitInfo(UnitName, const.Unit_Points),
  Demand = UnitInfo(UnitName, const.Unit_Supply),
  DamageType = "extreme",
  PoisonDrain = 1,
  Bombs = {Value = 0, Max = 1, Increase = 0, Enable = true},
  Mines = {Value = 0, Max = 1, Increase = 0, Enable = true},
  CanCastSpell = {"spell-technician-armor-repair", "spell-place-mine", "spell-place-charge", "spell-technician-repair", "spell-place-mine-for-ai"},
  AutoCastActive = {"spell-technician-armor-repair", "spell-technician-repair"},
  -- Damage and armor part
  BasicDamage = 1, PiercingDamage = 1, Missile = "missile-grenade",
  IsLightArmor = 1,
  BaseDamage = BaseDamage,

  LightArmorDamage = GetArmorDamage(BaseDamage, DamageType, 1),
  CombatArmorDamage = GetArmorDamage(BaseDamage, DamageType, 2),
  HeavyArmorDamage = GetArmorDamage(BaseDamage, DamageType, 3),
  
  FleshArmorDamage = GetArmorDamage(BaseDamage, DamageType, 4),
  HeavyFleshArmorDamage = GetArmorDamage(BaseDamage, DamageType, 5),
  AirFleshArmorDamage = GetArmorDamage(BaseDamage, DamageType, 6),
  
  MechanicalArmorDamage = GetArmorDamage(BaseDamage, DamageType, 7),
  AirMechanicalArmorDamage = GetArmorDamage(BaseDamage, DamageType, 8),
  
  BuildingArmorDamage = GetArmorDamage(BaseDamage, DamageType, 9),
  HeavyBuildingArmorDamage = GetArmorDamage(BaseDamage, DamageType, 10),

  CursedArmorDamage = GetCursedDamage(BaseDamage),
  ----------------------
  -- Flags
  ArmorShield = 1,
  UAC = true,
  CanAttack = true, 
  DetectCloak = true,
  ShowArmor = true,
  CanTargetLand = true,
  LandUnit = true,
  organic = true,
  SelectableByRectangle = true,
  SphereMarine = true,
  -- Other
  PriorityTarget = {"HeavyFlesh", "only", "Mechanical", "only", "Building", "only"},
  RightMouseAction = "attack",
  OnEachSecond = UpdateVeteranStatus,
  OnHit = MarineInvulnSphereHit,
  Sounds = {
    "selected", "technician-selected",
    "acknowledge", "technician-acknowledge",
	"attack","technician-attack",
    "ready", "technician-ready",
    "help", "uac unit under attack",
	"dead", "extreme","vgavnonah",
	"dead", "fire","marine fire death",
    "dead", "uac marine death"} } )

DefineUnitType("unit-technician-body", { Name = _("Technician Body"),
  Image = {"file", "graphics/uac/units/technician.png", "size", {42, 42}},
  Animations = "animations-technician-body", Icon = "icon-cancel",
  HitPoints = 100,
  DrawLevel = 10,
  Indestructible = 1,
  IsHeavyFleshArmor = 1,
  NumDirections = 8, Flip = false,
  NoRandomPlacing = true,
  TileSize = {1, 1}, BoxSize = {31, 31},
  SightRange = 0,
  Arg1 = 3600,
  OnEachCycle = HandleDefibrillation,
  BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  Priority = 0,
  Type = "land",
  NonSolid = true,
  UAC = true,
  Dead = true,
  IsNotSelectable = true,
  Sounds = {} })