local list = ListFilesInDirectory("scripts/hell/units/")
for i,f in ipairs(list) do
	if (string.find(f, "^unit-.*%.lua$")) then
		--DebugPrint("Loading unit: " .. f .. "\n")
		Load("scripts/hell/units/"..f)
	end
end

local function HellKeepIncomeManagement(slot)
	if (GameCycle % 1800 == 0) then
		SetUnitVariable(slot, "OldMinProduct", GetUnitVariable(slot, "MinProduct", "Value"), "Value")
		SetUnitVariable(slot, "OldEngProduct", GetUnitVariable(slot, "EngProduct", "Value"), "Value")
		SetUnitVariable(slot, "MinProduct", GetPlayerData(GetUnitVariable(slot, "Player"), "Resources", "minerals"), "Value")
		SetUnitVariable(slot, "EngProduct", GetPlayerData(GetUnitVariable(slot, "Player"), "Resources", "energy"), "Value")
	end
end

DefineUnitType("unit-hellkeep", { Name = _("Hell Keep"),
  -- Drawing
  Image = {"file","graphics/hell/buildings/keep.png","size", {160, 159}},
  Shadow = {"file", "graphics/hell/buildings/keep-s.png", "size",{160, 159}},
  Animations = "animations-hellkeep", Icon = "icon-hellkeep",
  Offset = {0, -16},
  BoxOffset = {0, -16},
  DrawLevel = 40,
  TileSize = {5, 4}, BoxSize = {159, 158},
  Type = "land",
  -- Properties
  Costs = {"time", 300, "minerals", 4000},
  RepairHp = 2,
  Storing = {"energy", 400},
  RepairCosts = {"minerals", 2, "energy", 1},
  HitPoints = 1800,
  CanStore = {"minerals"},
  IsBuildingArmor = 1,
  OnHit = ResetSmoke,
  SightRange = 5,
  AiAdjacentRange = 3,
  Priority = 10, 
  Points = 300,
  ArtifactGive = 150,
  RadarResearch = 120,
  Supply = 5,
  CanCastSpell = {"spell-enable-trade", "spell-trading-prev-player", "spell-trading-next-player", "spell-trading-inc-min",
  "spell-trading-dec-min", "spell-trading-inc-eng", "spell-trading-dec-eng", "spell-trading-commit"},
  -- Damage and armor part
  BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  -- Flags
  Hell = true,
  LandUnit = true,
  Building = true,
  VisibleUnderFog = true,
  Center = true,
  -- Other
  Construction = "construction-hellkeep",
  DeathExplosion = BigBuildingExplosion,
  OnEachCycle = SmokeControlHellKeep,
  OnEachSecond = HellKeepIncomeManagement,
  Corpse = "unit-destroyed-5x4-place",
  BuildingRules = { { "distance", { Distance = 1, DistanceType = ">", Type = "unit-mineral-mine"},
					  "distance", { Distance = 1, DistanceType = ">", Type = "unit-mineral-piece"}}
				  },
  AiBuildingRules = { {
					"distance", { Distance = 12, DistanceType = "<=", Type = "unit-mineral-piece"},
					"distance", { Distance = 2, DistanceType = ">", Type = "unit-barracks"},
					"distance", { Distance = 2, DistanceType = ">", Type = "unit-vehicle-factory"},
					"distance", { Distance = 1, DistanceType = ">", Type = "unit-chaingun-tower"},
					"distance", { Distance = 1, DistanceType = ">", Type = "unit-missile-tower"},
					"distance", { Distance = 2, DistanceType = ">", Type = "unit-monster-spawner"},
					"distance", { Distance = 2, DistanceType = ">", Type = "unit-hellgate"},
					"distance", { Distance = 1, DistanceType = ">", Type = "unit-fire-tower"},
					"distance", { Distance = 1, DistanceType = ">", Type = "unit-upgraded-fire-tower"},
					"distance", { Distance = 1, DistanceType = ">", Type = "unit-horror-tower"},
					  "distance", { Distance = 15, DistanceType = ">", Type = "unit-hellkeep"},
					  "distance", { Distance = 15, DistanceType = ">", Type = "unit-command-center"},
					  "distance", { Distance = 15, DistanceType = ">", Type = "unit-advanced-command-center"}}
				  },
  Sounds = {
    "selected", "hell-keep",
	"acknowledge", "hell new-rally-point",
    "help", "hell base under attack",
    "dead", "building destroyed"} } )

DefineUnitType("unit-generator-hell", { Name = _("Generator of Hell Power"),
  Image = {"file","graphics/hell/buildings/generator.png","size", {128, 152}},
  Shadow = {"file", "graphics/hell/buildings/generator-s.png", "size",{128, 152}},
  Animations = "animations-generator", Icon = "icon-generator-hell",
  Costs = {"time", 135, "minerals", 1500},
  Storing = {"energy", 100},
  RepairHp = 2,
  Offset = {0, -24},
  BoxOffset = {0, -14},
  OnHit = ResetSmoke,
  OnEachSecond = PowerPlantControlHellSmall,
  RepairCosts = {"minerals", 2, "energy", 1},
  Construction = "construction-generator-hell", 
  HitPoints = 750,
  ArtifactGive = 35,
  RadarResearch = 35,
  DrawLevel = 40,
  PlantValue = true,
  ProductMax = 12,
  AiAdjacentRange = 0,
  TileSize = {4, 3}, BoxSize = {127, 127},
  SightRange = 3,
  BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  AiBuildingRules = { {"distance", { Distance = 2, DistanceType = ">", Type = "unit-barracks"},
					"distance", { Distance = 3, DistanceType = ">", Type = "unit-hellkeep"},
					"distance", { Distance = 3, DistanceType = ">", Type = "unit-command-center"},
					"distance", { Distance = 3, DistanceType = ">", Type = "unit-advanced-command-center"},
					"distance", { Distance = 2, DistanceType = ">", Type = "unit-vehicle-factory"},
					"distance", { Distance = 1, DistanceType = ">", Type = "unit-chaingun-tower"},
					"distance", { Distance = 1, DistanceType = ">", Type = "unit-missile-tower"},
					"distance", { Distance = 2, DistanceType = ">", Type = "unit-monster-spawner"},
					"distance", { Distance = 2, DistanceType = ">", Type = "unit-hellgate"},
					"distance", { Distance = 1, DistanceType = ">", Type = "unit-fire-tower"},
					"distance", { Distance = 1, DistanceType = ">", Type = "unit-upgraded-fire-tower"},
					"distance", { Distance = 1, DistanceType = ">", Type = "unit-horror-tower"},
					"distance", { Distance = 3, DistanceType = ">", Type = "unit-lostsoul"},
					  "distance", { Distance = 3, DistanceType = ">", Type = "unit-advanced-lostsoul"}}
				  },
  IsBuildingArmor = 1,
  Hell = true,
  Priority = 10,
  Points = 65,
  Supply = 9,
  Corpse = "unit-destroyed-4x3-place",
  OnEachCycle = SmokeControlGeneratorHell,
  DeathExplosion = MediumBuildingExplosion,
  Type = "land",
  LandUnit = true,
  Building = true, VisibleUnderFog = true, 
  Sounds = {
    "selected", "monster-plant",
    "help", "hell base under attack",
    "dead", "building destroyed"} } )

DefineUnitType("unit-advanced-generator-hell", { Name = _("Adv.Generator of Hell Power"),
  Image = {"file","graphics/hell/buildings/generator.png","size", {128, 152}},
  Shadow = {"file", "graphics/hell/buildings/generator-s.png", "size",{128, 152}},
  Animations = "animations-adv-generator", Icon = "icon-adv-generator-hell",
  Costs = {"time", 100, "minerals", 800,"energy", 200},
  Storing = {"energy", 120},
  RepairHp = 2,
  Offset = {0, -24},
  BoxOffset = {0, -20},
  PlantValue = true,
  RepairCosts = {"minerals", 2, "energy", 1},
  Construction = "construction-generator-hell", 
  HitPoints = 850,
  ArtifactGive = 50,
  RadarResearch = 45,
  DrawLevel = 40,
  ProductMax = 14,
  AiAdjacentRange = 0,
  TileSize = {4, 3}, BoxSize = {127, 140},
  SightRange = 3,
  BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  AiBuildingRules = { { "distance", { Distance = 2, DistanceType = ">", Type = "unit-barracks"},
					"distance", { Distance = 3, DistanceType = ">", Type = "unit-hellkeep"},
					"distance", { Distance = 3, DistanceType = ">", Type = "unit-command-center"},
					"distance", { Distance = 3, DistanceType = ">", Type = "unit-advanced-command-center"},
					"distance", { Distance = 2, DistanceType = ">", Type = "unit-vehicle-factory"},
					"distance", { Distance = 1, DistanceType = ">", Type = "unit-chaingun-tower"},
					"distance", { Distance = 1, DistanceType = ">", Type = "unit-missile-tower"},
					"distance", { Distance = 2, DistanceType = ">", Type = "unit-monster-spawner"},
					"distance", { Distance = 2, DistanceType = ">", Type = "unit-hellgate"},
					"distance", { Distance = 1, DistanceType = ">", Type = "unit-fire-tower"},
					"distance", { Distance = 1, DistanceType = ">", Type = "unit-upgraded-fire-tower"},
					"distance", { Distance = 1, DistanceType = ">", Type = "unit-horror-tower"},
					"distance", { Distance = 3, DistanceType = ">", Type = "unit-lostsoul"},
					  "distance", { Distance = 3, DistanceType = ">", Type = "unit-advanced-lostsoul"}}
				  },
  IsBuildingArmor = 1,
  Hell = true,
  Priority = 10,
  Points = 75,
  Supply = 10,
  OnHit = ResetSmoke,
  OnEachSecond = PowerPlantControlHellBig,
  OnEachCycle = SmokeControlAdvancedGeneratorHell,
  DeathExplosion = MediumBuildingExplosion,
  Corpse = "unit-destroyed-4x3-place",
  Type = "land",
  LandUnit = true,
  Building = true, VisibleUnderFog = true, 
  Sounds = {
    "selected", "monster-plant",
    "help", "hell base under attack",
    "dead", "building destroyed"} } )

DefineUnitType("unit-monster-spawner", { Name = _("Monster Spawner"),
  Image = {"file","graphics/hell/buildings/spawner.png","size", {128, 154}},
  Shadow = {"file", "graphics/hell/buildings/spawner-s.png", "size",{128, 154}},
  Animations = "animations-monster-barracks", Icon = "icon-monster-spawner",
  Costs = {"time", 160, "minerals", 1500},
  RepairHp = 2,
  Offset = {0, -28},
  BoxOffset = {0, -20},
  RepairCosts = {"minerals", 2, "energy", 1},
  Construction = "construction-mbarrack",  
  HitPoints = 850,
  ArtifactGive = 55,
  RadarResearch = 45,
  DrawLevel = 40,
  TileSize = {4, 3}, BoxSize = {127, 140},
  SightRange = 3,
  AiAdjacentRange = 2,
  IsBuildingArmor = 1,
  BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  AiBuildingRules = { { "distance", { Distance = 2, DistanceType = ">", Type = "unit-barracks"},
					"distance", { Distance = 3, DistanceType = ">", Type = "unit-hellkeep"},
					"distance", { Distance = 3, DistanceType = ">", Type = "unit-command-center"},
					"distance", { Distance = 3, DistanceType = ">", Type = "unit-advanced-command-center"},
					"distance", { Distance = 2, DistanceType = ">", Type = "unit-vehicle-factory"},
					"distance", { Distance = 1, DistanceType = ">", Type = "unit-chaingun-tower"},
					"distance", { Distance = 1, DistanceType = ">", Type = "unit-missile-tower"},
					"distance", { Distance = 2, DistanceType = ">", Type = "unit-monster-spawner"},
					"distance", { Distance = 2, DistanceType = ">", Type = "unit-hellgate"},
					"distance", { Distance = 1, DistanceType = ">", Type = "unit-fire-tower"},
					"distance", { Distance = 1, DistanceType = ">", Type = "unit-upgraded-fire-tower"},
					"distance", { Distance = 1, DistanceType = ">", Type = "unit-horror-tower"},
					"distance", { Distance = 3, DistanceType = ">", Type = "unit-lostsoul"},
					  "distance", { Distance = 3, DistanceType = ">", Type = "unit-advanced-lostsoul"}}
				  },
  Priority = 10, 
  Points = 65,
  Hell = true,
  OnHit = ResetSmoke,
  Corpse = "unit-destroyed-4x3-place",
  DeathExplosion = MediumBuildingExplosion,
  Type = "land",
  LandUnit = true,
  Building = true, VisibleUnderFog = true, 
  Sounds = {
    "selected", "monster-spawner",
	"acknowledge", "hell new-rally-point",
    "help", "hell base under attack",
    "dead", "building destroyed"} } )

local function HellGateStart(slot)
	local bitset = bit.tobits(GetUnitVariable(slot, "UnitFlags", "Value"))
	if (bitset[unitFlagsIndex.UFI_UpgradePortal] == 1 and bitset[unitFlagsIndex.UFI_Init] ~= 1) then
		SetUnitVariable(slot, "Charge", 1, "Enable")
		SetUnitVariable(slot, "Charge", 360, "Max")
		SetUnitVariable(slot, "Charge", 0, "Value")
		SetUnitVariable(slot, "Charge", 1, "Increase")
		SetUnitVariable(slot, "UnitFlags", GetUnitVariable(slot, "UnitFlags", "Value") + unitFlags.UF_Init, "Value")
	end
end

DefineUnitType("unit-hellgate", { Name = _("Hell Gate"),
  Image = {"file","graphics/hell/buildings/gate.png","size", {160, 178}},
  Shadow = {"file", "graphics/hell/buildings/gate-s.png", "size",{160, 178}},
  Animations = "animations-hellgate", Icon = "icon-hellgate",
  Costs = {"time", 220, "minerals", 3200, "energy", 550},
  RepairHp = 2,
  Offset = {0, -24},
  BoxOffset = {0, -24},
  RepairCosts = {"minerals", 2, "energy", 1},
  Construction = "construction-hellgate",
  HitPoints = 1000,
  ArtifactGive = 70,
  RadarResearch = 60,
  DrawLevel = 40,
  AiAdjacentRange = 2,
  TileSize = {5, 4}, BoxSize = {159, 177},
  SightRange = 3,
  BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  AiBuildingRules = { {"distance", { Distance = 2, DistanceType = ">", Type = "unit-barracks"},
					"distance", { Distance = 3, DistanceType = ">", Type = "unit-hellkeep"},
					"distance", { Distance = 3, DistanceType = ">", Type = "unit-command-center"},
					"distance", { Distance = 3, DistanceType = ">", Type = "unit-advanced-command-center"},
					"distance", { Distance = 2, DistanceType = ">", Type = "unit-vehicle-factory"},
					"distance", { Distance = 1, DistanceType = ">", Type = "unit-chaingun-tower"},
					"distance", { Distance = 1, DistanceType = ">", Type = "unit-missile-tower"},
					"distance", { Distance = 2, DistanceType = ">", Type = "unit-monster-spawner"},
					"distance", { Distance = 2, DistanceType = ">", Type = "unit-hellgate"},
					"distance", { Distance = 1, DistanceType = ">", Type = "unit-fire-tower"},
					"distance", { Distance = 1, DistanceType = ">", Type = "unit-upgraded-fire-tower"},
					"distance", { Distance = 1, DistanceType = ">", Type = "unit-horror-tower"},
					"distance", { Distance = 3, DistanceType = ">", Type = "unit-lostsoul"},
					  "distance", { Distance = 3, DistanceType = ">", Type = "unit-advanced-lostsoul"}}
				  },
  Priority = 10,
  CanCastSpell = {"spell-gate-exit"},
  Superweapon = true,
  Points = 80,
  IsBuildingArmor = 1,
  Hell = true,
  Corpse = "unit-destroyed-5x4-place",
  OnHit = ResetSmoke,
  OnEachCycle = SmokeControlHellGate,
  OnEachSecond = HellGateStart,
  DeathExplosion = BigBuildingExplosion,
  TeleportEffectIn = ParticleTeleportFlashOnUnit,
  TeleportEffectOut = ParticleTeleportFlashOnUnit,
  Type = "land",
  LandUnit = true,
  Teleporter = true,
  Building = true, VisibleUnderFog = true, 
  Sounds = {
    "selected", "hellgate",
    "acknowledge", "hell new-rally-point",
    "help", "hell base under attack",
    "dead", "building destroyed"} } )
	
DefineUnitType("unit-temple-of-fire", { Name = _("Temple of Fire"),
  Image = {"file","graphics/hell/buildings/temple.png","size", {160, 146}},
  Shadow = {"file", "graphics/hell/buildings/temple-s.png", "size",{160, 146}},
  Animations = "animations-temple-of-fire", Icon = "icon-temple-of-fire",
  Costs = {"time", 280, "minerals", 3700, "energy", 700},
  RepairHp = 2,
  Offset = {0,-10},
  BoxOffset = {0, -10},
  AiAdjacentRange = 0,
  RepairCosts = {"minerals", 2, "energy", 1},
  Construction = "construction-temple-of-fire", 
  HitPoints = 1200,
  ArtifactGive = 90,
  RadarResearch = 75,
  DrawLevel = 40,
  IsBuildingArmor = 1,
  TileSize = {5, 4}, BoxSize = {159, 140},
  SightRange = 3,
  BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  AiBuildingRules = { { "distance", { Distance = 2, DistanceType = ">", Type = "unit-barracks"},
					"distance", { Distance = 3, DistanceType = ">", Type = "unit-hellkeep"},
					"distance", { Distance = 3, DistanceType = ">", Type = "unit-command-center"},
					"distance", { Distance = 3, DistanceType = ">", Type = "unit-advanced-command-center"},
					"distance", { Distance = 2, DistanceType = ">", Type = "unit-vehicle-factory"},
					"distance", { Distance = 1, DistanceType = ">", Type = "unit-chaingun-tower"},
					"distance", { Distance = 1, DistanceType = ">", Type = "unit-missile-tower"},
					"distance", { Distance = 2, DistanceType = ">", Type = "unit-monster-spawner"},
					"distance", { Distance = 2, DistanceType = ">", Type = "unit-hellgate"},
					"distance", { Distance = 1, DistanceType = ">", Type = "unit-fire-tower"},
					"distance", { Distance = 1, DistanceType = ">", Type = "unit-upgraded-fire-tower"},
					"distance", { Distance = 1, DistanceType = ">", Type = "unit-horror-tower"},
					"distance", { Distance = 3, DistanceType = ">", Type = "unit-lostsoul"},
					  "distance", { Distance = 3, DistanceType = ">", Type = "unit-advanced-lostsoul"}}
				  },
  Priority = 10,
  Points = 90,
  Hell = true,
  Corpse = "unit-destroyed-5x4-place",
  OnHit = ResetSmoke,
  OnEachCycle = SmokeControlTempleOfFire,
  DeathExplosion = BigBuildingExplosion,
  Type = "land",
  LandUnit = true,
  Building = true, VisibleUnderFog = true, 
  Sounds = {
    "selected", "temple-of-fire",
    "help", "hell base under attack",
    "dead", "building destroyed"} } )

local function DeathPentagramStart(slot)
	local bitset = bit.tobits(GetUnitVariable(slot, "UnitFlags", "Value"))
	if (bitset[unitFlagsIndex.UFI_Init] ~= 1) then
		SetUnitVariable(slot, "Charge", 1, "Enable")
		SetUnitVariable(slot, "Charge", 360, "Max")
		SetUnitVariable(slot, "Charge", 0, "Value")
		SetUnitVariable(slot, "Charge", 1, "Increase")
		bitset[unitFlagsIndex.UFI_Init] = 1
		bitset[unitFlagsIndex.UFI_SuperweaponCharged] = 0
		SetUnitVariable(slot, "UnitFlags", bit.tonumb(bitset), "Value")
	end
	if (bitset[unitFlagsIndex.UFI_SuperweaponCharged] ~= 1 and GetUnitVariable(slot, "Charge", "Value") == 360) then
		if (GetUnitVariable(slot, "Player") == GetThisPlayer()) then
			local weapon = GetUnitVariable(slot, "Weapon")
			if (weapon == 0) then
				AddMessage("We can summon Cyberdemon now!")
				PlaySound("hell cyberdemon ready")
			elseif (weapon == 1) then
				AddMessage("We can summon the Mastermind now!")
				PlaySound("hell mastermind ready")
			end
		end
		bitset[unitFlagsIndex.UFI_SuperweaponCharged] = 1
		SetUnitVariable(slot, "UnitFlags", bit.tonumb(bitset), "Value")
	end
end

DefineUnitType("unit-death-pentagram", { Name = _("Pentagram of Death"),
  Image = {"file","graphics/hell/buildings/pentagram.png","size", {160, 121}},
  Animations = "animations-deathpentagram", Icon = "icon-death-pentagram",
  Costs = {"time", 400, "minerals", 5000, "energy", 1000},
  RepairHp = 2,
  Offset = {0, 8},
  RepairCosts = {"minerals", 2, "energy", 1},
  Construction = "construction-deathpentagram",
  HitPoints = 1500,
  ArtifactGive = 120,
  RadarResearch = 105,
  DrawLevel = 40,
  IsBuildingArmor = 1,
  Hell = true,
  Superweapon = true,
  AiAdjacentRange = 0,
  TileSize = {5, 4}, BoxSize = {159, 120},
  SightRange = 3, ComputerReactionRange = 128, PersonReactionRange = 128,
  BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  Priority = 10,
  OnHit = ResetSmoke,
  CanCastSpell = {"spell-spider-summon","spell-cyber-summon","spell-cyber-summon-for-ai"},
  AiBuildingRules = { {"distance", { Distance = 2, DistanceType = ">", Type = "unit-barracks"},
					"distance", { Distance = 3, DistanceType = ">", Type = "unit-hellkeep"},
					"distance", { Distance = 3, DistanceType = ">", Type = "unit-command-center"},
					"distance", { Distance = 3, DistanceType = ">", Type = "unit-advanced-command-center"},
					"distance", { Distance = 2, DistanceType = ">", Type = "unit-vehicle-factory"},
					"distance", { Distance = 1, DistanceType = ">", Type = "unit-chaingun-tower"},
					"distance", { Distance = 1, DistanceType = ">", Type = "unit-missile-tower"},
					"distance", { Distance = 2, DistanceType = ">", Type = "unit-monster-spawner"},
					"distance", { Distance = 2, DistanceType = ">", Type = "unit-hellgate"},
					"distance", { Distance = 1, DistanceType = ">", Type = "unit-fire-tower"},
					"distance", { Distance = 1, DistanceType = ">", Type = "unit-upgraded-fire-tower"},
					"distance", { Distance = 1, DistanceType = ">", Type = "unit-horror-tower"},
					"distance", { Distance = 3, DistanceType = ">", Type = "unit-lostsoul"},
					  "distance", { Distance = 3, DistanceType = ">", Type = "unit-advanced-lostsoul"}}
				  },
  Points = 180,
  Corpse = "unit-destroyed-5x4-place",
  DeathExplosion = BigBuildingExplosion,
  OnEachSecond = DeathPentagramStart,
  CanAttack = true,
  CanTargetLand = true, CanTargetSea = true, CanTargetAir = false,
  Type = "land",
  LandUnit = true,
  Building = true, VisibleUnderFog = true,
  Sounds = {
    "selected", "death-pentagram",
    "help", "hell base under attack",
    "dead", "building destroyed"} } )
	
DefineUnitType("unit-well", { Name = _("Well of Souls"),
  Image = {"file","graphics/hell/buildings/wellofsouls.png","size", {96, 80}},
  Shadow = {"file", "graphics/hell/buildings/wellofsouls-s.png", "size",{96, 80}},
  Animations = "animations-well-of-souls", Icon = "icon-well-of-souls",
  Costs = {"time", 200, "minerals", 1400, "energy", 400},
  RepairHp = 2,
  RepairCosts = {"minerals", 2, "energy", 1},
  Construction = "construction-well-of-souls",  
  HitPoints = 400,
  ArtifactGive = 45,
  RadarResearch = 45,
  DrawLevel = 40,
  CanCastSpell = {"spell-well-heal","spell-well-charge"},
  AutoCastActive = {"spell-well-heal","spell-well-charge"},
  Mana = {Value = 400, Max = 400, Increase = 2, Enable = true},
  Offset = {0, 8},
  AiAdjacentRange = 2,
  TileSize = {3, 3}, BoxSize = {95, 95},
  AiBuildingRules = { { "distance", { Distance = 2, DistanceType = ">", Type = "unit-barracks"},
					"distance", { Distance = 3, DistanceType = ">", Type = "unit-hellkeep"},
					"distance", { Distance = 3, DistanceType = ">", Type = "unit-command-center"},
					"distance", { Distance = 3, DistanceType = ">", Type = "unit-advanced-command-center"},
					"distance", { Distance = 2, DistanceType = ">", Type = "unit-vehicle-factory"},
					"distance", { Distance = 1, DistanceType = ">", Type = "unit-chaingun-tower"},
					"distance", { Distance = 1, DistanceType = ">", Type = "unit-missile-tower"},
					"distance", { Distance = 2, DistanceType = ">", Type = "unit-monster-spawner"},
					"distance", { Distance = 2, DistanceType = ">", Type = "unit-hellgate"},
					"distance", { Distance = 1, DistanceType = ">", Type = "unit-fire-tower"},
					"distance", { Distance = 1, DistanceType = ">", Type = "unit-upgraded-fire-tower"},
					"distance", { Distance = 1, DistanceType = ">", Type = "unit-horror-tower"},
					"distance", { Distance = 3, DistanceType = ">", Type = "unit-lostsoul"},
					  "distance", { Distance = 3, DistanceType = ">", Type = "unit-advanced-lostsoul"}}
				  },
  SightRange = 3,
  IsBuildingArmor = 1,
  BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  CanTargetLand = true, CanTargetSea = true, CanTargetAir = true,
  Priority = 10, 
  Points = 70,
  Hell = true,
  Corpse = "unit-destroyed-3x3-place",
  DeathExplosion = BigBuildingExplosion,
  Type = "land",
  OnHit = ResetSmoke,
  LandUnit = true,
  Building = true, VisibleUnderFog = true, 
  Sounds = {
    "selected", "well-of-souls",
    "help", "hell base under attack",
    "dead", "building destroyed"} } )

BaseDamage = 14
DamageType = "fire"
DefineUnitType("unit-fire-tower", { Name = _("Fire Tower"),
  Image = {"file","graphics/hell/buildings/firetower.png","size", {32, 55}},
  Shadow = {"file", "graphics/hell/buildings/firetower-s.png", "size",{32, 55},"offset", {4, -12}},
  Animations = "animations-fire-tower", Icon = "icon-fire-tower",
  Costs = {"time", 100, "minerals", 700, "energy", 110},
  RepairHp = 2,
  RepairCosts = {"minerals", 2, "energy", 1},
  Construction = "construction-fire-tower",
  HitPoints = 150,
  ArtifactGive = 20,
  RadarResearch = 20,
  DrawLevel = 40,
  AiAdjacentRange = 1,
  DamageType = "fire",
  OnHit = ResetSmoke,
  OnEachCycle = SmokeControlFireTower,
  AiBuildingRules = { { "distance", { Distance = 3, DistanceType = ">", Type = "unit-lostsoul"},
					  "distance", { Distance = 3, DistanceType = ">", Type = "unit-advanced-lostsoul"},
					  "distance", { Distance = 3, DistanceType = ">", Type = "unit-hellkeep"},
					  "distance", { Distance = 3, DistanceType = ">", Type = "unit-generator-hell"},
					  "distance", { Distance = 3, DistanceType = ">", Type = "unit-advanced-generator-hell"},
					  "distance", { Distance = 3, DistanceType = ">", Type = "unit-monster-spawner"},
					  "distance", { Distance = 3, DistanceType = ">", Type = "unit-blood-pool"},
					  "distance", { Distance = 3, DistanceType = ">", Type = "unit-hellgate"},
					  "distance", { Distance = 3, DistanceType = ">", Type = "unit-temple-of-fire"},
					  "distance", { Distance = 3, DistanceType = ">", Type = "unit-death-pentagram"},
					  "distance", { Distance = 3, DistanceType = ">", Type = "unit-well"},
					  "distance", { Distance = 3, DistanceType = ">", Type = "unit-fire-tower"},
					  "distance", { Distance = 3, DistanceType = ">", Type = "unit-upgraded-fire-tower"},
					  "distance", { Distance = 3, DistanceType = ">", Type = "unit-horror-tower"}}
				  },				
  -- Damage and armor part
  IsHeavyBuildingArmor = 1,
  BaseDamage = BaseDamage,

  LightArmorDamage = GetArmorDamage(BaseDamage, DamageType, 1),
  CombatArmorDamage = GetArmorDamage(BaseDamage, DamageType, 2),
  HeavyArmorDamage = GetArmorDamage(BaseDamage, DamageType, 3),
  
  FleshArmorDamage = GetArmorDamage(BaseDamage, DamageType, 4),
  HeavyFleshArmorDamage = GetArmorDamage(BaseDamage, DamageType, 5),
  AirFleshArmorDamage = GetArmorDamage(BaseDamage, DamageType, 6),
  
  MechanicalArmorDamage = GetArmorDamage(BaseDamage, DamageType, 7),
  AirMechanicalArmorDamage = GetArmorDamage(BaseDamage, DamageType, 8),
  
  BuildingArmorDamage = GetArmorDamage(BaseDamage, DamageType, 9),
  HeavyBuildingArmorDamage = GetArmorDamage(BaseDamage, DamageType, 10),
  
  CursedArmorDamage = GetCursedDamage(BaseDamage),
  ----------------------
  Hell = true,
  PriorityTarget = {"organic", "only", "Mechanical", "false", "Building", "only"},
  TileSize = {1, 1}, BoxSize = {31, 54},
  SightRange = 9, ComputerReactionRange = 9, PersonReactionRange = 9,
  BasicDamage = 1, PiercingDamage = 1, Missile = "missile-imp-ball",
  MaxAttackRange = 5,
  Priority = 30, 
  Points = 55,
  Corpse = "unit-destroyed-1x1-place",
  DeathExplosion = TinyBuildingExplosion,
  Type = "land",
  RightMouseAction = "attack",
  CanAttack = true,
  LandUnit = true,
  BuilderOutside = true,
  Building = true, CanTargetLand = true, CanTargetSea = true,CanTargetAir = true,
  VisibleUnderFog = true, 
  DetectCloak = true,
  Sounds = {
    "selected", "fire-tower",
    "help", "hell base under attack",
    "dead", "building destroyed"} } )

BaseDamage = 22
DamageType = "high-explosion"
DefineUnitType("unit-upgraded-fire-tower", { Name = _("Advanced Fire Tower"),
  Image = {"file","graphics/hell/buildings/firetower.png","size", {32, 55}},
  Shadow = {"file", "graphics/hell/buildings/firetower-s.png", "size",{32, 55},"offset", {4, -12}},
  Animations = "animations-upgraded-fire-tower", Icon = "icon-fire-tower",
  Costs = {"time", 60, "minerals", 600, "energy", 180},
  RepairHp = 2,
  ArtifactGive = 30,
  RadarResearch = 30,
  RepairCosts = {"minerals", 2, "energy", 1},
  AiAdjacentRange = 1,
  Construction = "construction-fire-tower",
  OnHit = ResetSmoke,
  OnEachCycle = SmokeControlFireTower,
  AiBuildingRules = { { "distance", { Distance = 3, DistanceType = ">", Type = "unit-lostsoul"},
					  "distance", { Distance = 3, DistanceType = ">", Type = "unit-advanced-lostsoul"},
					  "distance", { Distance = 3, DistanceType = ">", Type = "unit-hellkeep"},
					  "distance", { Distance = 3, DistanceType = ">", Type = "unit-generator-hell"},
					  "distance", { Distance = 3, DistanceType = ">", Type = "unit-advanced-generator-hell"},
					  "distance", { Distance = 3, DistanceType = ">", Type = "unit-monster-spawner"},
					  "distance", { Distance = 3, DistanceType = ">", Type = "unit-blood-pool"},
					  "distance", { Distance = 3, DistanceType = ">", Type = "unit-hellgate"},
					  "distance", { Distance = 3, DistanceType = ">", Type = "unit-temple-of-fire"},
					  "distance", { Distance = 3, DistanceType = ">", Type = "unit-death-pentagram"},
					  "distance", { Distance = 3, DistanceType = ">", Type = "unit-well"},
					  "distance", { Distance = 3, DistanceType = ">", Type = "unit-fire-tower"},
					  "distance", { Distance = 3, DistanceType = ">", Type = "unit-upgraded-fire-tower"},
					  "distance", { Distance = 3, DistanceType = ">", Type = "unit-horror-tower"}}
				  },
  HitPoints = 180,
  DrawLevel = 40,
  
  -- Damage and armor part
  IsHeavyBuildingArmor = 1,
  BaseDamage = BaseDamage,

  LightArmorDamage = GetArmorDamage(BaseDamage, DamageType, 1),
  CombatArmorDamage = GetArmorDamage(BaseDamage, DamageType, 2),
  HeavyArmorDamage = GetArmorDamage(BaseDamage, DamageType, 3),
  
  FleshArmorDamage = GetArmorDamage(BaseDamage, DamageType, 4),
  HeavyFleshArmorDamage = GetArmorDamage(BaseDamage, DamageType, 5),
  AirFleshArmorDamage = GetArmorDamage(BaseDamage, DamageType, 6),
  
  MechanicalArmorDamage = GetArmorDamage(BaseDamage, DamageType, 7),
  AirMechanicalArmorDamage = GetArmorDamage(BaseDamage, DamageType, 8),
  
  BuildingArmorDamage = GetArmorDamage(BaseDamage, DamageType, 9),
  HeavyBuildingArmorDamage = GetArmorDamage(BaseDamage, DamageType, 10),
  
  CursedArmorDamage = GetCursedDamage(BaseDamage),
  ----------------------
  Hell = true,
  TileSize = {1, 1}, BoxSize = {31, 54},
  SightRange = 9, ComputerReactionRange = 9, PersonReactionRange = 9,
  BasicDamage = 1, PiercingDamage = 1, Missile = "missile-revenant-missile",
  MaxAttackRange = 6,
  Priority = 30, 
  Points = 85,
  Corpse = "unit-destroyed-1x1-place",
  DeathExplosion = TinyBuildingExplosion,
  Type = "land",
  RightMouseAction = "attack",
  CanAttack = true,
  LandUnit = true,
  BuilderOutside = true,
  Building = true, CanTargetLand = true, CanTargetAir = true,
  VisibleUnderFog = true, 
  DetectCloak = true,
  Sounds = {
    "selected", "fire-tower",
    "help", "hell base under attack",
    "dead", "building destroyed"} } )

BaseDamage = 55
DamageType = "plasma"
DefineUnitType("unit-horror-tower", { Name = _("Tower of Horror"),
  Image = {"file","graphics/hell/buildings/horrortower.png","size", {64, 96}},
  Shadow = {"file", "graphics/hell/buildings/horrortower-s.png", "size",{64, 96},"offset", {1, 0}},
  Animations = "animations-tower-of-horror", Icon = "icon-horror-tower",
  Costs = {"time", 140, "minerals", 2000, "energy", 450},
  RepairHp = 2,
  Offset = {0, -16},
  ArtifactGive = 40,
  RadarResearch = 45,
  RepairCosts = {"minerals", 2, "energy", 1},
  Construction = "construction-horror-tower", 
  HitPoints = 300,
  DrawLevel = 40,
  AiAdjacentRange = 1,
  OnHit = ResetSmoke,
  CanCastSpell = {"spell-make-zombie"},
  AutoCastActive = {"spell-make-zombie"},
  MissileOffsets = {{{8, -40}, {18, -32}, {18, -32}, {18, -24}, {18, -24}, {8, -24}, {8, -32}, {8, -40}}},
  OnEachCycle = SmokeControlHorrorTower,
  AiBuildingRules = { { "distance", { Distance = 3, DistanceType = ">", Type = "unit-lostsoul"},
					  "distance", { Distance = 3, DistanceType = ">", Type = "unit-advanced-lostsoul"},
					  "distance", { Distance = 3, DistanceType = ">", Type = "unit-hellkeep"},
					  "distance", { Distance = 3, DistanceType = ">", Type = "unit-generator-hell"},
					  "distance", { Distance = 3, DistanceType = ">", Type = "unit-advanced-generator-hell"},
					  "distance", { Distance = 3, DistanceType = ">", Type = "unit-monster-spawner"},
					  "distance", { Distance = 3, DistanceType = ">", Type = "unit-blood-pool"},
					  "distance", { Distance = 3, DistanceType = ">", Type = "unit-hellgate"},
					  "distance", { Distance = 3, DistanceType = ">", Type = "unit-temple-of-fire"},
					  "distance", { Distance = 3, DistanceType = ">", Type = "unit-death-pentagram"},
					  "distance", { Distance = 3, DistanceType = ">", Type = "unit-well"},
					  "distance", { Distance = 3, DistanceType = ">", Type = "unit-fire-tower"},
					  "distance", { Distance = 3, DistanceType = ">", Type = "unit-upgraded-fire-tower"},
					  "distance", { Distance = 3, DistanceType = ">", Type = "unit-horror-tower"}}
				  },
  -- Damage and armor part
  IsHeavyBuildingArmor = 1,
  BaseDamage = BaseDamage,

  LightArmorDamage = GetArmorDamage(BaseDamage, DamageType, 1),
  CombatArmorDamage = GetArmorDamage(BaseDamage, DamageType, 2),
  HeavyArmorDamage = GetArmorDamage(BaseDamage, DamageType, 3),
  
  FleshArmorDamage = GetArmorDamage(BaseDamage, DamageType, 4),
  HeavyFleshArmorDamage = GetArmorDamage(BaseDamage, DamageType, 5),
  AirFleshArmorDamage = GetArmorDamage(BaseDamage, DamageType, 6),
  
  MechanicalArmorDamage = GetArmorDamage(BaseDamage, DamageType, 7),
  AirMechanicalArmorDamage = GetArmorDamage(BaseDamage, DamageType, 8),
  
  BuildingArmorDamage = GetArmorDamage(BaseDamage, DamageType, 9),
  HeavyBuildingArmorDamage = GetArmorDamage(BaseDamage, DamageType, 10),
  
  CursedArmorDamage = GetCursedDamage(BaseDamage),
  ----------------------
  Hell = true,
  TileSize = {2, 2}, BoxSize = {63, 63},
  SightRange = 9, ComputerReactionRange = 9, PersonReactionRange = 9,
  BasicDamage = 1, PiercingDamage = 1, Missile = "missile-hellfire",
  PriorityTarget = {"AirUnit", "false"},
  MaxAttackRange = 8,
  Priority = 30,
  Points = 120,
  Corpse = "unit-destroyed-2x2-place",
  DeathExplosion = SmallBuildingExplosion,
  RightMouseAction = "attack",
  Type = "land",
  CanAttack = true,
  LandUnit = true,
  BuilderOutside = true,
  CanTargetLand = true, CanTargetSea = true,CanTargetAir = false,
  Building = true, VisibleUnderFog = true, 
  DetectCloak = true,
  Sounds = {
    "selected", "horror-tower",
    "help", "hell base under attack",
    "dead", "building destroyed"} } )

DefineUnitType("unit-hell-wall", { Name = _("Wall"),
  Image = {"file","graphics/hell/buildings/wall.png","size", {32, 32}},
  Animations = "animations-hell-wall", Icon = "icon-hell-wall",
  Costs = {"time", 30, "minerals", 50},
  Construction = "construction-hell-wall",
  HitPoints = 120,
  DrawLevel = 40,
  TileSize = {1, 1}, BoxSize = {31, 31},
  SightRange = 0,
  BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  Priority = 0,
  Points = 0,
  IsHeavyBuildingArmor = 1,
  NumDirections = 16, Flip = false,
  Corpse = "unit-destroyed-1x1-place",
  Type = "land",
  BuilderOutside = true,
  Coward = true,
  Building = true, VisibleUnderFog = true, Wall = true,
  IsNotSelectable = true,
  Sounds = {
    "dead", "building destroyed"} } )

DefineUnitType("unit-hell-wall-compat", { Name = _("Wall"),
  Image = {"file","graphics/hell/buildings/wall.png","size", {32, 32}},
  Animations = "animations-hell-wall", Icon = "icon-hell-wall",
  Costs = {"time", 30, "minerals", 50},
  Construction = "construction-hell-wall",
  HitPoints = 120,
  DrawLevel = 40,
  TileSize = {1, 1}, BoxSize = {31, 31},
  SightRange = 0,
  BasicDamage = 0, PiercingDamage = 0, Missile = "missile-none",
  Priority = 0,
  Points = 0,
  IsHeavyBuildingArmor = 1,
  NumDirections = 16, Flip = false,
  Corpse = "unit-destroyed-1x1-place",
  Type = "land",
  BuilderOutside = true,
  Coward = true,
  Building = true, VisibleUnderFog = true, Wall = true,
  IsNotSelectable = true,
  Sounds = {
    "dead", "building destroyed"} } )